# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# Mobius Forensic Toolkit
# Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022,2023 Eduardo Aguiar
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
# Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Generic data holder
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class dataholder (object):
  pass

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief decode FileFragments structure
# @see FileFragments/Compatibility.hpp - SerializeIn1
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
def decode1 (decoder, version):
  fragments = []

  if version >= 29:
    total = decoder.get_qword ()
    remaining = decoder.get_qword ()
  else:
    total = decoder.get_dword ()
    remaining = decoder.get_dword ()

  count = decoder.get_dword ()

  for i in range (count):
    fragment = decode_fragment (decoder, version)
    fragments.append (fragment)

  return fragments

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief decode FileFragments structure
# @see FileFragments/Compatibility.hpp - SerializeIn2
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
def decode2 (decoder, version):
  fragments = []

  if version >= 20:
    count = decoder.get_count ()

    for i in range (count):
      fragment = decode_fragment (decoder, version)
      fragments.append (fragment)

  elif version >= 5:
    while decoder.get_count () > 0:
      fragment = decode_fragment (decoder, version)
      fragments.append (fragment)

  return fragments

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief decode FileFragment structure
# @see FileFragments/Compatibility.hpp - SerializeIn
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
def decode_fragment (decoder, version):
  fragment = dataholder ()

  if version >= 29:
    fragment.begin = decoder.get_qword ()
    fragment.length = decoder.get_qword ()
  else:
    fragment.begin = decoder.get_dword ()
    fragment.length = decoder.get_dword ()

  return fragment
