#ifndef MOBIUS_FORENSICS_TURING_TURING_H
#define MOBIUS_FORENSICS_TURING_TURING_H

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <mobius/forensics/turing/hash.h>
#include <mobius/database/transaction.h>
#include <mobius/database/connection_pool.h>
#include <mobius/bytearray.h>
#include <string>
#include <vector>

namespace mobius
{
namespace forensics
{
namespace turing
{
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief turing manager class
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class turing
{
public:
  mobius::database::connection_pool::connection new_connection ();
  mobius::database::transaction new_transaction ();
  void test_keyword (const std::string&);

  hash new_hash (const std::string&, const std::string&);
  hash get_hash (const std::string&, const std::string&) const;
  void remove_hash (const std::string&, const std::string&);
  std::vector <hash> get_hashes () const;
};

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// helper functions
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
mobius::bytearray generate_nt_hash (const std::string&);
mobius::bytearray generate_lm_hash (const std::string&);
mobius::bytearray generate_msdcc1_hash (const std::string&, const std::string&);
} // namespace turing
} // namespace forensics
} // namespace mobius

#endif
