// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include "hash.h"
#include "hash_adler32.h"
#include "hash_crc32.h"
#include "hash_md4.h"
#include "hash_md5.h"
#include "hash_sha1.h"
#include "hash_sha2_224.h"
#include "hash_sha2_256.h"
#include "hash_sha2_384.h"
#include "hash_sha2_512.h"
#include "hash_sha2_512_224.h"
#include "hash_sha2_512_256.h"
#include "hash_zip.h"
#include <mobius/exception.inc>
#include <stdexcept>

namespace mobius
{
namespace crypt
{

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief initialize object
//! \param hash_id hash class ID (md5, sha1, ...)
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
hash::hash (const std::string& hash_id)
{
  if (hash_id == "adler32")
    pimpl_.reset (new mobius::crypt::hash_adler32);

  else if (hash_id == "crc32")
    pimpl_.reset (new mobius::crypt::hash_crc32);

  else if (hash_id == "md4")
    pimpl_.reset (new mobius::crypt::hash_md4);

  else if (hash_id == "md5")
    pimpl_.reset (new mobius::crypt::hash_md5);

  else if (hash_id == "sha1")
    pimpl_.reset (new mobius::crypt::hash_sha1);

  else if (hash_id == "sha2_224")
    pimpl_.reset (new mobius::crypt::hash_sha2_224);

  else if (hash_id == "sha2_256")
    pimpl_.reset (new mobius::crypt::hash_sha2_256);

  else if (hash_id == "sha2_384")
    pimpl_.reset (new mobius::crypt::hash_sha2_384);

  else if (hash_id == "sha2_512")
    pimpl_.reset (new mobius::crypt::hash_sha2_512);

  else if (hash_id == "sha2_512_224")
    pimpl_.reset (new mobius::crypt::hash_sha2_512_224);

  else if (hash_id == "sha2_512_256")
    pimpl_.reset (new mobius::crypt::hash_sha2_512_256);

  else if (hash_id == "zip")
    pimpl_.reset (new mobius::crypt::hash_zip);

  else
    throw std::invalid_argument (MOBIUS_EXCEPTION_MSG ("invalid hash ID"));
}

} // namespace crypt
} // namespace mobius

