#ifndef MOBIUS_CRYPT_CIPHER_BLOCK_MODE_IMPL_IGE_H
#define MOBIUS_CRYPT_CIPHER_BLOCK_MODE_IMPL_IGE_H

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <mobius/crypt/cipher_block_mode_impl_base.h>
#include <mobius/bytearray.h>

namespace mobius
{
namespace crypt
{
class cipher_block;

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Infinite Garble Extension (IGE) block cipher mode implementation class
//! \author Eduardo Aguiar
//! \see https://mgp25.com/AESIGE/
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class cipher_block_mode_impl_ige : public cipher_block_mode_impl_base
{
public:
  // function prototypes
  cipher_block_mode_impl_ige (cipher_block&, const mobius::bytearray&);
  void encrypt (mobius::bytearray&) override;
  void decrypt (mobius::bytearray&) override;
  void reset () override;

private:
  cipher_block& cipher_;
  const mobius::bytearray iv_;
  mobius::bytearray v1_;
  mobius::bytearray v2_;
};

} // namespace crypt
} // namespace mobius

#endif
