// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief C++ API module wrapper
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <pymobius.h>
#include "filesystem_ext2.h"
#include "filesystem.h"
#include "api_metadata.h"

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: tp_dealloc
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static void
tp_dealloc (filesystem_filesystem_ext2_o *self)
{
  delete self->obj;
  self->ob_type->tp_free ((PyObject*) self);
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: volume_uuid getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_volume_uuid (filesystem_filesystem_ext2_o *self)
{
  return PyString2_from_std_string (self->obj->get_volume_uuid ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: volume_name getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_volume_name (filesystem_filesystem_ext2_o *self)
{
  return PyString2_from_std_string (self->obj->get_volume_name ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: creator_os getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_creator_os (filesystem_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_creator_os ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: inodes_count getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_inodes_count (filesystem_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_inodes_count ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: blocks_count getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_blocks_count (filesystem_filesystem_ext2_o *self)
{
  return mobius::py::pylong_from_std_uint64_t (self->obj->get_blocks_count ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: root_blocks_count getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_root_blocks_count (filesystem_filesystem_ext2_o *self)
{
  return mobius::py::pylong_from_std_uint64_t (self->obj->get_root_blocks_count ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: free_blocks_count getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_free_blocks_count (filesystem_filesystem_ext2_o *self)
{
  return mobius::py::pylong_from_std_uint64_t (self->obj->get_free_blocks_count ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: free_inodes_count getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_free_inodes_count (filesystem_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_free_inodes_count ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: first_data_block getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_first_data_block (filesystem_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_first_data_block ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: block_size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_block_size (filesystem_filesystem_ext2_o *self)
{
  return mobius::py::pylong_from_std_uint64_t (self->obj->get_block_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: cluster_size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_cluster_size (filesystem_filesystem_ext2_o *self)
{
  return mobius::py::pylong_from_std_uint64_t (self->obj->get_cluster_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: blocks_per_group getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_blocks_per_group (filesystem_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_blocks_per_group ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: clusters_per_group getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_clusters_per_group (filesystem_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_clusters_per_group ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: inodes_per_group getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_inodes_per_group (filesystem_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_inodes_per_group ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: creation_time getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_creation_time (filesystem_filesystem_ext2_o *self)
{
  return mobius::py::pydatetime_from_datetime (self->obj->get_creation_time ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: last_mount_time getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_last_mount_time (filesystem_filesystem_ext2_o *self)
{
  return mobius::py::pydatetime_from_datetime (self->obj->get_last_mount_time ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: last_write_time getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_last_write_time (filesystem_filesystem_ext2_o *self)
{
  return mobius::py::pydatetime_from_datetime (self->obj->get_last_write_time ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: last_check_time getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_last_check_time (filesystem_filesystem_ext2_o *self)
{
  return mobius::py::pydatetime_from_datetime (self->obj->get_last_check_time ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: first_error_time getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_first_error_time (filesystem_filesystem_ext2_o *self)
{
  return mobius::py::pydatetime_from_datetime (self->obj->get_first_error_time ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: last_error_time getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_last_error_time (filesystem_filesystem_ext2_o *self)
{
  return mobius::py::pydatetime_from_datetime (self->obj->get_last_error_time ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: mount_count getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_mount_count (filesystem_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_mount_count ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: max_mount_count getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_max_mount_count (filesystem_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_max_mount_count ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: state getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_state (filesystem_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_state ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: errors getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_errors (filesystem_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_errors ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: error_count getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_error_count (filesystem_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_error_count ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: minor_revision_level getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_minor_revision_level (filesystem_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_minor_revision_level ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: check_interval getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_check_interval (filesystem_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_check_interval ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: revision_level getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_revision_level (filesystem_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_revision_level ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: def_resuid getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_def_resuid (filesystem_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_def_resuid ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: def_resgid getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_def_resgid (filesystem_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_def_resgid ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: first_inode getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_first_inode (filesystem_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_first_inode ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: inode_size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_inode_size (filesystem_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_inode_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: block_group_number getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_block_group_number (filesystem_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_block_group_number ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: feature_compat getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_feature_compat (filesystem_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_feature_compat ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: feature_incompat getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_feature_incompat (filesystem_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_feature_incompat ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: feature_read_only getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_feature_read_only (filesystem_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_feature_read_only ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: last_mount_point getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_last_mount_point (filesystem_filesystem_ext2_o *self)
{
  return PyString2_from_std_string (self->obj->get_last_mount_point ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: journal_uuid getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_journal_uuid (filesystem_filesystem_ext2_o *self)
{
  return PyString2_from_std_string (self->obj->get_journal_uuid ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: journal_inode getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_journal_inode (filesystem_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_journal_inode ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: journal_device getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_journal_device (filesystem_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_journal_device ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: default_hash_version getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_default_hash_version (filesystem_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_default_hash_version ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: default_mount_options getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_default_mount_options (filesystem_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_default_mount_options ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: mount_options getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_mount_options (filesystem_filesystem_ext2_o *self)
{
  return PyString2_from_std_string (self->obj->get_mount_options ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: kib_written getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_kib_written (filesystem_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_kib_written ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: checksum getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_checksum (filesystem_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_checksum ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: getters and setters structure
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyGetSetDef tp_getset[] =
{
  {
    (char *) "volume_uuid",
    (getter) tp_getter_volume_uuid,
    (setter) 0,
    (char *) "volume UUID", NULL
  },
  {
    (char *) "volume_name",
    (getter) tp_getter_volume_name,
    (setter) 0,
    (char *) "volume name", NULL
  },
  {
    (char *) "creator_os",
    (getter) tp_getter_creator_os,
    (setter) 0,
    (char *) "creator operating system", NULL
  },
  {
    (char *) "inodes_count",
    (getter) tp_getter_inodes_count,
    (setter) 0,
    (char *) "total inode count", NULL
  },
  {
    (char *) "blocks_count",
    (getter) tp_getter_blocks_count,
    (setter) 0,
    (char *) "total block count", NULL
  },
  {
    (char *) "root_blocks_count",
    (getter) tp_getter_root_blocks_count,
    (setter) 0,
    (char *) "number of blocks allocated by root", NULL
  },
  {
    (char *) "free_blocks_count",
    (getter) tp_getter_free_blocks_count,
    (setter) 0,
    (char *) "free blocks count", NULL
  },
  {
    (char *) "free_inodes_count",
    (getter) tp_getter_free_inodes_count,
    (setter) 0,
    (char *) "free inode count", NULL
  },
  {
    (char *) "first_data_block",
    (getter) tp_getter_first_data_block,
    (setter) 0,
    (char *) "first data block", NULL
  },
  {
    (char *) "block_size",
    (getter) tp_getter_block_size,
    (setter) 0,
    (char *) "block size in bytes", NULL
  },
  {
    (char *) "cluster_size",
    (getter) tp_getter_cluster_size,
    (setter) 0,
    (char *) "cluster size in bytes", NULL
  },
  {
    (char *) "blocks_per_group",
    (getter) tp_getter_blocks_per_group,
    (setter) 0,
    (char *) "blocks per group", NULL
  },
  {
    (char *) "clusters_per_group",
    (getter) tp_getter_clusters_per_group,
    (setter) 0,
    (char *) "clusters per group", NULL
  },
  {
    (char *) "inodes_per_group",
    (getter) tp_getter_inodes_per_group,
    (setter) 0,
    (char *) "inodes per group", NULL
  },
  {
    (char *) "creation_time",
    (getter) tp_getter_creation_time,
    (setter) 0,
    (char *) "filesystem creation date/time", NULL
  },
  {
    (char *) "last_mount_time",
    (getter) tp_getter_last_mount_time,
    (setter) 0,
    (char *) "last mount date/time", NULL
  },
  {
    (char *) "last_write_time",
    (getter) tp_getter_last_write_time,
    (setter) 0,
    (char *) "last write date/time", NULL
  },
  {
    (char *) "last_check_time",
    (getter) tp_getter_last_check_time,
    (setter) 0,
    (char *) "last check date/time", NULL
  },
  {
    (char *) "first_error_time",
    (getter) tp_getter_first_error_time,
    (setter) 0,
    (char *) "first error date/time", NULL
  },
  {
    (char *) "last_error_time",
    (getter) tp_getter_last_error_time,
    (setter) 0,
    (char *) "last error date/time", NULL
  },
  {
    (char *) "mount_count",
    (getter) tp_getter_mount_count,
    (setter) 0,
    (char *) "number of mounts since the last fsck", NULL
  },
  {
    (char *) "max_mount_count",
    (getter) tp_getter_max_mount_count,
    (setter) 0,
    (char *) "number of mounts for mandatory fsck", NULL
  },
  {
    (char *) "state",
    (getter) tp_getter_state,
    (setter) 0,
    (char *) "file system state", NULL
  },
  {
    (char *) "errors",
    (getter) tp_getter_errors,
    (setter) 0,
    (char *) "action when detecting errors", NULL
  },
  {
    (char *) "error_count",
    (getter) tp_getter_error_count,
    (setter) 0,
    (char *) "number of errors", NULL
  },
  {
    (char *) "minor_revision_level",
    (getter) tp_getter_minor_revision_level,
    (setter) 0,
    (char *) "minor revision level", NULL
  },
  {
    (char *) "check_interval",
    (getter) tp_getter_check_interval,
    (setter) 0,
    (char *) "max check interval time in seconds", NULL
  },
  {
    (char *) "revision_level",
    (getter) tp_getter_revision_level,
    (setter) 0,
    (char *) "revision level", NULL
  },
  {
    (char *) "def_resuid",
    (getter) tp_getter_def_resuid,
    (setter) 0,
    (char *) "default uid for reserved blocks", NULL
  },
  {
    (char *) "def_resgid",
    (getter) tp_getter_def_resgid,
    (setter) 0,
    (char *) "default gid for reserved blocks", NULL
  },
  {
    (char *) "first_inode",
    (getter) tp_getter_first_inode,
    (setter) 0,
    (char *) "first non-reserved inode", NULL
  },
  {
    (char *) "inode_size",
    (getter) tp_getter_inode_size,
    (setter) 0,
    (char *) "inode size in bytes", NULL
  },
  {
    (char *) "block_group_number",
    (getter) tp_getter_block_group_number,
    (setter) 0,
    (char *) "block group number of this superblock", NULL
  },
  {
    (char *) "feature_compat",
    (getter) tp_getter_feature_compat,
    (setter) 0,
    (char *) "compatible features flags", NULL
  },
  {
    (char *) "feature_incompat",
    (getter) tp_getter_feature_incompat,
    (setter) 0,
    (char *) "incompatible features flags", NULL
  },
  {
    (char *) "feature_read_only",
    (getter) tp_getter_feature_read_only,
    (setter) 0,
    (char *) "readonly compatible features flags", NULL
  },
  {
    (char *) "last_mount_point",
    (getter) tp_getter_last_mount_point,
    (setter) 0,
    (char *) "last mounting point", NULL
  },
  {
    (char *) "journal_uuid",
    (getter) tp_getter_journal_uuid,
    (setter) 0,
    (char *) "journal superblock UUID", NULL
  },
  {
    (char *) "journal_inode",
    (getter) tp_getter_journal_inode,
    (setter) 0,
    (char *) "journal inode number", NULL
  },
  {
    (char *) "journal_device",
    (getter) tp_getter_journal_device,
    (setter) 0,
    (char *) "journal device number", NULL
  },
  {
    (char *) "default_hash_version",
    (getter) tp_getter_default_hash_version,
    (setter) 0,
    (char *) "default hash algorithm", NULL
  },
  {
    (char *) "default_mount_options",
    (getter) tp_getter_default_mount_options,
    (setter) 0,
    (char *) "default mount options", NULL
  },
  {
    (char *) "mount_options",
    (getter) tp_getter_mount_options,
    (setter) 0,
    (char *) "mount options", NULL
  },
  {
    (char *) "kib_written",
    (getter) tp_getter_kib_written,
    (setter) 0,
    (char *) "KiB written into this filesystem", NULL
  },
  {
    (char *) "checksum",
    (getter) tp_getter_checksum,
    (setter) 0,
    (char *) "superblock checksum", NULL
  },
  {NULL, NULL, 0, NULL, NULL} // sentinel
};

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_ext2: type structure
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyTypeObject filesystem_filesystem_ext2_t =
{
  PyVarObject_HEAD_INIT (NULL, 0)
  "mobius.filesystem.filesystem_ext2",        		// tp_name
  sizeof (filesystem_filesystem_ext2_o),       		// tp_basicsize
  0,                                          		// tp_itemsize
  (destructor) tp_dealloc,	                     	// tp_dealloc
  0,                                          		// tp_print
  0,                                          		// tp_getattr
  0,                                          		// tp_setattr
  0,                                          		// tp_compare
  0,                                          		// tp_repr
  0,                                          		// tp_as_number
  0,                                          		// tp_as_sequence
  0,                                          		// tp_as_mapping
  0,                                          		// tp_hash
  0,                                          		// tp_call
  0,                                          		// tp_str
  0,                                          		// tp_getattro
  0,                                          		// tp_setattro
  0,                                          		// tp_as_buffer
  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,   		// tp_flags
  "filesystem_ext2 class",                    		// tp_doc
  0,                                          		// tp_traverse
  0,                                          		// tp_clear
  0,                                          		// tp_richcompare
  0,                                          		// tp_weaklistoffset
  0,                                          		// tp_iter
  0,                                          		// tp_iternext
  0,                                    		// tp_methods
  0,                                          		// tp_members
  tp_getset,             	                      	// tp_getset
  &filesystem_filesystem_t,                    		// tp_base
  0,                                          		// tp_dict
  0,                                          		// tp_descr_get
  0,                                          		// tp_descr_set
  0,                                          		// tp_dictoffset
  0,                                          		// tp_init
  0,                                          		// tp_alloc
  0,                                          		// tp_new
  0,                                       		// tp_free
  0,                                       		// tp_is_gc
  0,                                       		// tp_bases
  0,                                       		// tp_mro
  0,                                       		// tp_cache
  0,                                       		// tp_subclasses
  0,                                       		// tp_weaklist
  0,                                       		// tp_del
  0,                                       		// tp_version_tag
};
