// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include "registry_key_impl_lsa.h"
#include "registry_data_impl_lsa_polseckey.h"
#include "registry_data_impl_lsa_poleklist.h"
#include "registry_value.h"

namespace mobius
{
namespace forensics
{
namespace registry
{
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief constructor
//! \param key delegated key
//! \param lsa_key LSA Secrets encryption key
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
registry_key_impl_lsa::registry_key_impl_lsa (registry_key key, const mobius::bytearray& lsa_key, type t)
  : key_ (key),
    name_ (key.get_name ()),
    lsa_key_ (lsa_key),
    type_ (t)
{
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief load values on demand
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
void
registry_key_impl_lsa::_load_values () const
{
  // return if values are loaded
  if (values_loaded_)
    return;

  // load values from LSA Secret key
  for (auto k_value : key_.get_values ())
    {
      registry_data data;

      auto v_data = k_value.get_data ().get_data ();

      if (type_ == type::polseckey)
        data = registry_data (
                 std::make_shared <registry_data_impl_lsa_polseckey> (lsa_key_, v_data)
               );

      else if (type_ == type::poleklist)
        data = registry_data (
                 std::make_shared <registry_data_impl_lsa_poleklist> (lsa_key_, v_data)
               );

      registry_value value (k_value.get_name (), data);
      values_.push_back (value);
    }

  // set values loaded
  values_loaded_ = true;
}

} // namespace registry
} // namespace forensics
} // namespace mobius
