// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \file C++ API <i>mobius.crypt</i> module wrapper
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <Python.h>
#include "cipher_aes.h"
#include "cipher_des.h"
#include "cipher_rc4.h"
#include "cipher_rot13.h"
#include "cipher_zip.h"
#include "hash_adler32.h"
#include "hash_crc32.h"
#include "hash_md5.h"
#include "hash_sha1.h"
#include "hash_sha2_224.h"
#include "hash_sha2_256.h"
#include "hash_sha2_384.h"
#include "hash_sha2_512.h"
#include "hash_sha2_512_224.h"
#include "hash_sha2_512_256.h"
#include "hash_zip.h"

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief module methods
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyMethodDef module_methods[] =
{
  {
    NULL,
    NULL,
    0,
    NULL
  } // sentinel
};

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief create mobius.crypt module
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyObject *
new_crypt_module ()
{
  // initialize module mobius.crypt
  PyObject* module = Py_InitModule3 (
                       "crypt",
                       module_methods,
                       "Mobius Forensic Toolkit mobius.crypt module"
                     );

  // build types
  if (PyType_Ready (&crypt_cipher_aes_t) < 0)
    return nullptr;

  if (PyType_Ready (&crypt_cipher_des_t) < 0)
    return nullptr;

  if (PyType_Ready (&crypt_cipher_rc4_t) < 0)
    return nullptr;

  if (PyType_Ready (&crypt_cipher_rot13_t) < 0)
    return nullptr;

  if (PyType_Ready (&crypt_cipher_zip_t) < 0)
    return nullptr;

  if (PyType_Ready (&crypt_hash_adler32_t) < 0)
    return nullptr;

  if (PyType_Ready (&crypt_hash_crc32_t) < 0)
    return nullptr;

  if (PyType_Ready (&crypt_hash_md5_t) < 0)
    return nullptr;

  if (PyType_Ready (&crypt_hash_sha1_t) < 0)
    return nullptr;

  if (PyType_Ready (&crypt_hash_sha2_224_t) < 0)
    return nullptr;

  if (PyType_Ready (&crypt_hash_sha2_256_t) < 0)
    return nullptr;

  if (PyType_Ready (&crypt_hash_sha2_384_t) < 0)
    return nullptr;

  if (PyType_Ready (&crypt_hash_sha2_512_t) < 0)
    return nullptr;

  if (PyType_Ready (&crypt_hash_sha2_512_224_t) < 0)
    return nullptr;

  if (PyType_Ready (&crypt_hash_sha2_512_256_t) < 0)
    return nullptr;

  if (PyType_Ready (&crypt_hash_zip_t) < 0)
    return nullptr;

  // add types
  Py_INCREF (&crypt_cipher_aes_t);
  PyModule_AddObject (module, "cipher_aes", (PyObject *) &crypt_cipher_aes_t);

  Py_INCREF (&crypt_cipher_des_t);
  PyModule_AddObject (module, "cipher_des", (PyObject *) &crypt_cipher_des_t);

  Py_INCREF (&crypt_cipher_rc4_t);
  PyModule_AddObject (module, "cipher_rc4", (PyObject *) &crypt_cipher_rc4_t);

  Py_INCREF (&crypt_cipher_rot13_t);
  PyModule_AddObject (module, "cipher_rot13", (PyObject *) &crypt_cipher_rot13_t);

  Py_INCREF (&crypt_cipher_zip_t);
  PyModule_AddObject (module, "cipher_zip", (PyObject *) &crypt_cipher_zip_t);

  Py_INCREF (&crypt_hash_adler32_t);
  PyModule_AddObject (module, "hash_adler32", (PyObject *) &crypt_hash_adler32_t);

  Py_INCREF (&crypt_hash_crc32_t);
  PyModule_AddObject (module, "hash_crc32", (PyObject *) &crypt_hash_crc32_t);

  Py_INCREF (&crypt_hash_md5_t);
  PyModule_AddObject (module, "hash_md5", (PyObject *) &crypt_hash_md5_t);

  Py_INCREF (&crypt_hash_sha1_t);
  PyModule_AddObject (module, "hash_sha1", (PyObject *) &crypt_hash_sha1_t);

  Py_INCREF (&crypt_hash_sha2_224_t);
  PyModule_AddObject (module, "hash_sha2_224", (PyObject *) &crypt_hash_sha2_224_t);

  Py_INCREF (&crypt_hash_sha2_256_t);
  PyModule_AddObject (module, "hash_sha2_256", (PyObject *) &crypt_hash_sha2_256_t);

  Py_INCREF (&crypt_hash_sha2_384_t);
  PyModule_AddObject (module, "hash_sha2_384", (PyObject *) &crypt_hash_sha2_384_t);

  Py_INCREF (&crypt_hash_sha2_512_t);
  PyModule_AddObject (module, "hash_sha2_512", (PyObject *) &crypt_hash_sha2_512_t);

  Py_INCREF (&crypt_hash_sha2_512_224_t);
  PyModule_AddObject (module, "hash_sha2_512_224", (PyObject *) &crypt_hash_sha2_512_224_t);

  Py_INCREF (&crypt_hash_sha2_512_256_t);
  PyModule_AddObject (module, "hash_sha2_512_256", (PyObject *) &crypt_hash_sha2_512_256_t);

  Py_INCREF (&crypt_hash_zip_t);
  PyModule_AddObject (module, "hash_zip", (PyObject *) &crypt_hash_zip_t);

  // return module
  return module;
}
