#!/usr/bin/env python

import mobius
import datetime
import sys

def show_entry (r, level=0):
  is_folder = isinstance (r, mobius.io.folder)
  indent = ' ' * (level * 2)

  if not r.is_valid or not r.exists:
    print '%s? %s' % (indent, r.url)
    return

  # show metadata
  print
  print '%s%s %s' % (indent, '+' if is_folder else '.', r.url)
  print '%s  User: %s (%d)' % (indent, r.user_name, r.user_id)
  print '%s  Group: %s (%d)' % (indent, r.group_name, r.group_id)
  print '%s  Permissions: %o' % (indent, r.permissions)  
  print '%s  Last access time (atime): %s' % (indent, r.access_time)
  print '%s  Last modification time (mtime): %s' % (indent, r.modification_time)
  print '%s  Last metadata time (ctime): %s' % (indent, r.metadata_time)

  # if resource is a file, show some bytes...
  if not is_folder:
    print '%s  size: %d' % (indent, r.size)

    if r.is_regular_file ():
      try:
        reader = r.new_reader ()
        data = reader.read (16)
        print '%s  first 16 bytes: %s' % (indent, ' '.join ('%02x' % ord (c) for c in data))
      except Exception, e:
        print '%s  <Warning: %s>' % (indent, e)
  
  # otherwise resource is a folder, so recurse into it
  else:
    try:
      for child in r.children:
        show_entry (child, level+1)
    except Exception, e:
      print '%s  <Warning: %s>' % (indent, e)

for path in sys.argv[1:]:
  entry = mobius.io.new_entry_by_path (path)
  show_entry (entry)  
