// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief  C++ API module wrapper
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <pymobius.h>
#include "device.h"
#include <mobius/system/device_list.h>
#include <algorithm>

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief function mobius.system.get_devices
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyObject*
func_get_devices (PyObject *, PyObject *args)
{
  // parse arguments
  const char *arg_subsystem = nullptr;
  const char *arg_type = nullptr;

  if (!PyArg_ParseTuple (args, "|ss", &arg_subsystem, &arg_type))
    return nullptr;

  // create list
  PyObject *ret = nullptr;

  // populate list
  try
    {
      mobius::system::device_list dev_list;

      std::vector <mobius::system::device> selected_dev_list;
      std::copy_if (
              dev_list.begin (),
              dev_list.end (),
              std::back_inserter (selected_dev_list),
              [arg_subsystem, arg_type] (const auto& dev) {
                    return (arg_subsystem == nullptr || arg_subsystem == dev.get_subsystem ()) && (arg_type == nullptr || arg_type == dev.get_type ()); }
      );

      ret = mobius::py::pylist_from_cpp_container (
               selected_dev_list,
               PyMobius_System_Device_from_cpp
            );
    }
  catch (const std::exception& e)
    {
      PyErr_SetString (PyExc_Exception, e.what ());
    }

  return ret;
}
