# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# Mobius Forensic Toolkit
# Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018 Eduardo Aguiar
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
# Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
import pymobius
import pymobius.app.chrome

APP_ID = 'chrome'
APP_NAME = 'Chrome'

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Retrieve Google Chrome browser artifacts
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
def retrieve (os, item, model):

  # retrieve data from OS installed
  data = pymobius.app.chrome.retrieve (os)

  # add application
  app = pymobius.Data ()
  app.id = APP_ID
  app.name = APP_NAME
  app.versions = data.versions
  app.total_profiles = 0
  app.total_history = 0
  app.total_cookies = 0
  app.total_form_history = 0
  model.applications.append (app)

  # add profiles
  for profile in data.profiles:
    p = pymobius.Data ()
    p.app = APP_ID
    p.app_name = APP_NAME
    p.name = profile.name
    p.path = profile.path
    p.username = profile.username
    
    model.profiles.append (p)
    app.total_profiles += 1

    # add URL history
    for entry in profile.get_history ():
      h = pymobius.Data ()
      h.app = APP_ID
      h.app_name = APP_NAME
      h.url = entry.url
      h.timestamp = str (entry.timestamp)[:19]
      h.username = profile.username
      h.itemname = item.name
      h.profile_id = profile.name
      h.profile_path = profile.path

      h.metadata = []
      h.metadata.append (('Page Title', entry.title))

      model.history.append (h)
      app.total_history += 1

    # add cookies
    for entry in profile.get_cookies ():
      c = pymobius.Data ()
      c.app = APP_ID
      c.app_name = APP_NAME
      c.name = entry.name
      c.value = entry.value
      c.domain = entry.domain
      c.creation_time = str (entry.creation_time)[:19]
      c.username = profile.username
      c.itemname = item.name
      c.profile_id = profile.name
      c.profile_path = profile.path

      c.metadata = []
      c.metadata.append (('Last access date/time', str (entry.last_access_time)[:19]))

      model.cookies.append (c)
      app.total_cookies += 1

    # add form history
    for entry in profile.get_form_history ():
      h = pymobius.Data ()
      h.app = APP_ID
      h.app_name = APP_NAME
      h.username = profile.username
      h.fieldname = entry.fieldname
      h.itemname = item.name
      h.value = entry.value
      h.profile_id = profile.name
      h.profile_path = profile.path

      h.metadata = []
      h.metadata.append (('First used date/time', str (entry.first_used_time)[:19]))
      h.metadata.append (('Last used date/time', str (entry.last_used_time)[:19]))

      model.form_history.append (h)
      app.total_form_history += 1
      
    # add known files to KFF list
    for f in profile.get_known_files ():
      pymobius.file_set_handled (item, f, group='browser')
