/*
 *   This file is part of the MLV Library.
 *
 *   Copyright (C) 2010 Adrien Boussicault, Marc Zipstein
 *
 *
 *    This Library is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    This Library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this Library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "MLV_figures.h"

#ifndef MEMORY_DEBUG
#include <SDL/SDL_gfxPrimitives.h>
#else
#include "memory_debug.h"
#endif

#include "data_structure.h"
#include "warning_error.h"

#include "memory_management.h"

#include <stdarg.h>

extern DataMLV *MLV_data;

void MLV_draw_circle(int x, int y, int radius, MLV_Color color){
	circleColor( MLV_data->screen,	x, y, radius, color );
}

void MLV_draw_filled_circle(int x, int y, int radius, MLV_Color color){
	filledCircleColor( MLV_data->screen, x, y, radius,  color);
}

void MLV_draw_ellipse(int x, int y, int radius_x, int radius_y, MLV_Color color){
	ellipseColor(MLV_data->screen,x,y,radius_x,radius_y,color);      
}

void MLV_draw_filled_ellipse(int x, int y, int radius_x, int radius_y, MLV_Color color){
	filledEllipseColor(MLV_data->screen,x,y,radius_x,radius_y,color);      
}

void MLV_draw_polygon( const int* vx, const int* vy, int npoints, MLV_Color color){
	Sint16* tmp_vx = MLV_MALLOC( npoints, Sint16 );
	Sint16* tmp_vy = MLV_MALLOC( npoints, Sint16 );
	int i;
	for( i=0; i< npoints; i++){
		tmp_vx[i] = vx[i];
		tmp_vy[i] = vy[i];
	}
	polygonColor( MLV_data->screen, tmp_vx, tmp_vy, npoints, color);
	MLV_FREE( tmp_vx, Sint16 );
	MLV_FREE( tmp_vy, Sint16 );
}

void MLV_draw_filled_polygon( const int* vx, const int* vy, int npoints, MLV_Color color){
	Sint16* tmp_vx = MLV_MALLOC( npoints, Sint16 );
	Sint16* tmp_vy = MLV_MALLOC( npoints, Sint16 );
	int i;
	for( i=0; i< npoints; i++){
		tmp_vx[i] = vx[i];
		tmp_vy[i] = vy[i];
	}
	filledPolygonColor( MLV_data->screen, tmp_vx, tmp_vy, npoints, color);
	MLV_FREE( tmp_vx, Sint16 );
	MLV_FREE( tmp_vy, Sint16 );
}


void MLV_draw_bezier_curve( const int* vx, const int* vy, int npoints, MLV_Color color){
	Sint16* tmp_vx = MLV_MALLOC( npoints, Sint16 );
	Sint16* tmp_vy = MLV_MALLOC( npoints, Sint16 );
	int i;
	for( i=0; i< npoints; i++){
		tmp_vx[i] = vx[i];
		tmp_vy[i] = vy[i];
	}
	bezierColor( MLV_data->screen, tmp_vx, tmp_vy, npoints, 6 , color);
	MLV_FREE( tmp_vx, Sint16 );
	MLV_FREE( tmp_vy, Sint16 );
}


void MLV_draw_rectangle(int x, int y, int width, int height, MLV_Color color){
	rectangleColor(MLV_data->screen, x, y, x+width-1, y+height-1, color);
}

void MLV_draw_filled_rectangle(int x, int y, int width, int height, MLV_Color color){
	boxColor(MLV_data->screen, x, y, x+width-1, y+height-1, color);
}

void MLV_draw_line(int x1, int y1, int x2, int y2, MLV_Color color){
	lineColor( MLV_data->screen, x1, y1, x2, y2, color);
}

void MLV_draw_pixel(int x, int y, MLV_Color color){
	pixelColor( MLV_data->screen, x, y, color);
}

void MLV_draw_point(int x, int y, MLV_Color color){
	MLV_draw_pixel( x, y, color);
}

void MLV_save_screen(){
    SDL_BlitSurface( MLV_data->screen, NULL, MLV_data->save_screen, &(MLV_data->rectangle));
}

void MLV_load_screen(){
    SDL_BlitSurface( MLV_data->save_screen, NULL, MLV_data->screen, &(MLV_data->rectangle));
}

