/*
 *   This file is part of the MLV Library.
 *
 *   Copyright (C) 2010 Adrien Boussicault, Marc Zipstein
 *
 *
 *    This Library is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    This Library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this Library.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file MLV_window.h
 * \brief Ce fichier définit les prototypes des fonctions permettant de créer,
 * intialiser et fermer des fenêtres.
 *
 * \author Adrien Boussicault
 * \author Marc Zipstein
 * 
 */


#ifndef __MLV_INITIALISATION_H__
#define __MLV_INITIALISATION_H__

/** 
 * \brief Créé une fenêtre dont la taille, et les différents noms sont passés en paramètres.
 *
 * Cette fonction intialise la librairie MLV.
 * Un programme donné ne peut pas ouvrir plus d'une fenêtre à la
 * fois.
 *
 * \param display_name Le nom de la fenêtre
 * \param icone_name Le nom de l'icône de la fenêtre
 * \param width la largeur de la fenêtre
 * \param height la hauteur de la fenêtre
 */
void MLV_create_window(const char* display_name, const char* icone_name, int width, int height);


/**
 * \brief Ferme la fenêtre de la librairie MLV.
 *
 * Cette fonction libère correctement toutes les donées qui ont été crées par la
 * librairie MLV 
 *
 */
void MLV_close_window();

/** 
 * \brief Actualise l'affichage de la fenêtre.
 *
 * Lorsque vous utilisez des fonctions de dessins, les différents changements
 * effectués ne sont pas visibles. Pour les afficher vous devez utiliser cette
 * fonction.
 */
void MLV_actualise_window();

/** 
 * \brief Exécute la fonction de call back donnée en paraètre lorsque le système envoie un signal d'arrêt, ou lorsque l'utilisateur clique sur la croix de la fenêtre.
 *
 * La fonction de call back est alors exécutée avec en
 * paramêtre un pointeur vers une structure de donnée qui 
 * est aussi donné en paramètre à la fonction 
 * MLV_execute_at_exit.
 *
 * \param function pointeur de la fonction de call back qui  doit etre exécutée.
 * \param data Donnné à passer en parametre à la fonction de call back lors de son exécution.
 */
void MLV_execute_at_exit( void (*function)(void*), void* data );

#endif
