/* Copyright (C) 2012 Rudra Banerjee*/

/*
This file is part of mkbib.

mkbib is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

mkbib is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with mkbib.  If not, see <http://www.gnu.org/licenses/>.

*/

#include <gtk/gtk.h>
#include <string.h>
static void assistant_cancel (GtkAssistant*, gpointer);
static void assistant_close  (GtkAssistant*, gpointer);

typedef struct {
  GtkWidget *widget;
  gint index;
  const gchar *title;
  GtkAssistantPageType type;
  gboolean complete;
} PageInfo;
void helpassist (GtkMenuItem *helpabout, GtkWindow *parentWindow)
{
GtkWidget *assistant;
  guint i;
  PageInfo page[9] = {
    { NULL, -1, "Introduction",           GTK_ASSISTANT_PAGE_INTRO,   TRUE},
    { NULL, -1, "A Sample bibtex",        GTK_ASSISTANT_PAGE_CONTENT, FALSE},
    { NULL, -1, "Select File",            GTK_ASSISTANT_PAGE_CONTENT, FALSE},
    { NULL, -1, "Enter Content",          GTK_ASSISTANT_PAGE_CONTENT, FALSE},
    { NULL, -1, "Search Google",          GTK_ASSISTANT_PAGE_CONTENT, FALSE},
    { NULL, -1, "Convert to bibitem",     GTK_ASSISTANT_PAGE_CONTENT, FALSE},
    { NULL, -1, "Convert to bibitem II",  GTK_ASSISTANT_PAGE_CONTENT, FALSE},
    { NULL, -1, "More",                   GTK_ASSISTANT_PAGE_CONTENT, FALSE},
    { NULL, -1, "Bye",                    GTK_ASSISTANT_PAGE_SUMMARY, TRUE},
  };
  assistant = gtk_assistant_new ();
  gtk_widget_set_size_request (assistant, 450, 300);
  gtk_window_set_title (GTK_WINDOW (assistant), "mkBIB Assistant");
  g_signal_connect (G_OBJECT (assistant), "destroy",
                    G_CALLBACK (gtk_widget_destroy), NULL);
  
  page[0].widget = gtk_box_new (GTK_ORIENTATION_VERTICAL, 5); 
  page[1].widget = gtk_box_new (GTK_ORIENTATION_VERTICAL, 5); 
  page[2].widget = gtk_box_new (GTK_ORIENTATION_VERTICAL, 5); 
  page[3].widget = gtk_box_new (GTK_ORIENTATION_VERTICAL, 5); 
  page[4].widget = gtk_box_new (GTK_ORIENTATION_VERTICAL, 5);
  page[5].widget = gtk_box_new (GTK_ORIENTATION_VERTICAL, 5);
  page[6].widget = gtk_box_new (GTK_ORIENTATION_VERTICAL, 5);
  page[7].widget = gtk_box_new (GTK_ORIENTATION_VERTICAL, 5);
//  page[7].widget = gtk_box_new (GTK_ORIENTATION_VERTICAL, 5);

/*
 * Create Intro Page
 */
 GtkWidget *ast0lb = gtk_label_new ("This is a simple tutorial for mkBIB.\nThis will show you how to generate a bibtex file from scratch using mkBIB.");
 gtk_label_set_line_wrap(GTK_LABEL(ast0lb),TRUE);
  gchar *str=g_strdup_printf("%s/mkbib.png", PIXMAP);
  GtkWidget *ast0im = gtk_image_new_from_file (str);
  g_free (str);
  gtk_box_pack_start (GTK_BOX (page[0].widget), ast0im, FALSE, FALSE, 5);
  gtk_box_pack_start (GTK_BOX (page[0].widget), ast0lb, FALSE, FALSE, 5);

/*
 * Sample bibtex
 */
 GtkWidget *ast1lb = gtk_label_new ("A Sample bibtex entry");
 gtk_label_set_line_wrap(GTK_LABEL(ast0lb),TRUE);
  str=g_strdup_printf("%s/ast_smp.png", PIXMAP);
 GtkWidget *ast1im = gtk_image_new_from_file (str);
  g_free (str);
  gtk_box_pack_start (GTK_BOX (page[1].widget), ast1im, FALSE, FALSE, 5);
  gtk_box_pack_start (GTK_BOX (page[1].widget), ast1lb, FALSE, FALSE, 5);


/*
 * Create Select File
 */
  GtkWidget *ast2lb = gtk_label_new ("1. Open a file from folder.\n2. Select Entry type(Book, Article etc.)\n3. Enter bibkey");
  gtk_label_set_line_wrap(GTK_LABEL(ast1lb),TRUE);
  str=g_strdup_printf("%s/ast_slct.png", PIXMAP);
  GtkWidget *ast2im = gtk_image_new_from_file (str);
  g_free (str);
  gtk_box_pack_start (GTK_BOX (page[2].widget), ast2im, FALSE, FALSE, 5);
  gtk_box_pack_start (GTK_BOX (page[2].widget), ast2lb, FALSE, FALSE, 5);

/*
 * Create Enter Content
 */
  GtkWidget *ast3lb = gtk_label_new ("1. Enter the details like Author, Title etc.\n"\
                                     "2. When you are done, hit \"Create\""\
                                     "Remember: All possible options are shown here."\
                                     "You have to check which fields are necessary for a given type of entry.");
  gtk_label_set_line_wrap(GTK_LABEL(ast3lb),TRUE);
  str=g_strdup_printf("%s/ast_entry.png", PIXMAP);
  GtkWidget *ast3im = gtk_image_new_from_file (str);
  g_free (str);
  gtk_box_pack_start (GTK_BOX (page[3].widget), ast3im, FALSE, FALSE, 5);
  gtk_box_pack_start (GTK_BOX (page[3].widget), ast3lb, FALSE, FALSE, 5);


/*
 * Create Search Google
 */
  GtkWidget *ast4lb = gtk_label_new ("1. Enter essential query  like Author, Title and year(optional).\n"\
                                     "2. Hit \"Search Google Scholar\". Google Scholar search result will be "
				     "open in your default web-browser.");
  gtk_label_set_line_wrap(GTK_LABEL(ast4lb),TRUE);
  str=g_strdup_printf("%s/ast_gog.png", PIXMAP);
  GtkWidget *ast4im = gtk_image_new_from_file (str);
  g_free (str);
  gtk_box_pack_start (GTK_BOX (page[4].widget), ast4im, FALSE, FALSE, 5);
  gtk_box_pack_start (GTK_BOX (page[4].widget), ast4lb, FALSE, FALSE, 5);

/*
 * Create Convert to bibitem
 */
  GtkWidget *ast5lb1 = gtk_label_new ("The right part of the window is consists of 3 part");
  GtkWidget *ast5lb2 = gtk_label_new ("i. File that you have chosen\nii. Bibstyle to convert \niii. view of the file opened");
  gtk_label_set_line_wrap(GTK_LABEL(ast5lb1),TRUE);
  str=g_strdup_printf("%s/ast_bib1.png", PIXMAP);
  GtkWidget *ast5im = gtk_image_new_from_file (str);
  g_free (str);
  gtk_box_pack_start (GTK_BOX (page[5].widget), ast5lb1, FALSE, FALSE, 5);
  gtk_box_pack_start (GTK_BOX (page[5].widget), ast5im, FALSE, FALSE, 5);
  gtk_box_pack_start (GTK_BOX (page[5].widget), ast5lb2, FALSE, FALSE, 5);

/*
 * Create Convert to bibitem II
 */
  GtkWidget *ast6lb1 = gtk_label_new ("Selecting an bibliographystyle option from list will"\
                                      "create a file <bibliographystyle>.tex in your current directory");
  GtkWidget *ast6lb2 = gtk_label_new ("Remember: This bibstyle contains all bibstyle option distributed "\
                                      "with texlive 2012. All of them may not be present in your"\
                                      "latex installation, specially if you are using latex that"\
                                      "comes with your Linux distro. Choose cautiously");
  gtk_label_set_line_wrap(GTK_LABEL(ast6lb1),TRUE);
  gtk_label_set_line_wrap(GTK_LABEL(ast6lb2),TRUE);
  gtk_box_pack_start (GTK_BOX (page[6].widget), ast6lb1, FALSE, FALSE, 5);
  gtk_box_pack_start (GTK_BOX (page[6].widget), ast6lb2, FALSE, FALSE, 5);
  

/*
 * Create MORE File
 */
  GtkWidget *ast7lb1 =  gtk_label_new  ("Details of bibtex format is available here:");
  gtk_misc_set_alignment (GTK_MISC(ast7lb1),0,0);
  GtkWidget *ast7b1 =  gtk_link_button_new_with_label  ("http://bibtex.org/Format", "bibtex.org");
  GtkWidget *ast7lb2 =  gtk_label_new  ("BibTeX Style Examples");
  gtk_misc_set_alignment (GTK_MISC(ast7lb2),0,0);
  GtkWidget *ast7b2 =  gtk_link_button_new_with_label  ("http://www.cs.stir.ac.uk/~kjt/software/latex/showbst.html", "Ken Turner's Page on Bibtex");
  gtk_box_pack_start (GTK_BOX (page[7].widget), ast7lb1, FALSE, FALSE, 5);
  gtk_box_pack_start (GTK_BOX (page[7].widget), ast7b1, FALSE, FALSE, 5);
  gtk_box_pack_start (GTK_BOX (page[7].widget), ast7lb2, FALSE, FALSE, 5);
  gtk_box_pack_start (GTK_BOX (page[7].widget), ast7b2, FALSE, FALSE, 5);



  page[8].widget = gtk_label_new ("This mkBIB is created with the hope the it \n"\
                                "will be useful. Hope you will enjoy working with it.");
//  gtk_label_set_line_wrap(GTK_LABEL(ast5lb1),TRUE);

  for (i = 0; i < 9; i++)
  {
    page[i].index = gtk_assistant_append_page (GTK_ASSISTANT (assistant),
                                               page[i].widget);
    gtk_assistant_set_page_title (GTK_ASSISTANT (assistant),
                                  page[i].widget, page[i].title);
    gtk_assistant_set_page_type (GTK_ASSISTANT (assistant),
                                  page[i].widget, page[i].type);

    /* Set the introduction and conclusion pages as complete so they can be
     * incremented or closed. */
    gtk_assistant_set_page_complete (GTK_ASSISTANT (assistant),
                                     page[i].widget, TRUE);
  }
  g_signal_connect (G_OBJECT (assistant), "cancel",
                    G_CALLBACK (assistant_cancel), NULL);
  g_signal_connect (G_OBJECT (assistant), "close",
                    G_CALLBACK (assistant_close), NULL);

gtk_widget_show_all (assistant);

}
static void
assistant_cancel (GtkAssistant *assistant,
                  gpointer data)
{
  gtk_widget_destroy (GTK_WIDGET (assistant));
}

/* This function is where you would apply the changes and destroy the assistant. */
static void
assistant_close (GtkAssistant *assistant,
                 gpointer data)
{
//  g_print ("You would apply your changes now!\n");
  gtk_widget_destroy (GTK_WIDGET (assistant));
}
void helpfhelp(GtkWidget *widget, gpointer data)

{
  	gchar *uri, *str;
	GError *Err=NULL;

	uri=g_strdup("ghelp:mkbib-manual");
	gtk_show_uri(NULL, uri, gtk_get_current_event_time(), &Err);
	g_free(uri);
	if (Err)
	{
	  caution("File does not exist");
	}
}


