CREATE DATABASE Serveurs;
USE Serveurs;

--
-- Structure de la table `CONFIG`
--

DROP TABLE IF EXISTS `CONFIG`;
CREATE TABLE IF NOT EXISTS `CONFIG` (
  `Config_Id` int(11) NOT NULL auto_increment,
  `Module_Id` int(11) NOT NULL,
  `Colonne` varchar(30) NOT NULL,
  `Position` int(11) NOT NULL default '0',
  `IsKey` tinyint(1) NOT NULL,
  `Type` varchar(20) NOT NULL,
  `Value` varchar(120) NOT NULL,
  `Size` int(11) NOT NULL,
  `Total` tinyint(1) NOT NULL,
  `Wf` tinyint(1) NOT NULL,
  `Defaut` varchar(120) NOT NULL,
  `Afficher` tinyint(1) NOT NULL,
  `Label` varchar(30) NOT NULL,
  PRIMARY KEY  (`Config_Id`),
  KEY `Module_Id` (`Module_Id`)
) ENGINE=MyISAM  
  DEFAULT CHARSET=latin1 
          PACK_KEYS=0 
          AUTO_INCREMENT=489 ;


--
-- Structure de la table `DROIT`
--

DROP TABLE IF EXISTS `DROIT`;
CREATE TABLE IF NOT EXISTS `DROIT` (
  `Droit_Id` int(11) NOT NULL auto_increment,
  `Module_Id` int(11) NOT NULL,
  `Colonne` varchar(60) NOT NULL,
  `Role_Id` int(11) NOT NULL,
  `Read_Perm` tinyint(1) NOT NULL,
  `Write_Perm` tinyint(1) NOT NULL,
  `Workflow_Perm` tinyint(1) NOT NULL,
  PRIMARY KEY  (`Droit_Id`),
  KEY `Module_Id` (`Module_Id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=6838 ;



--
-- Structure de la table `FICHIER`
--

DROP TABLE IF EXISTS `FICHIER`;
CREATE TABLE IF NOT EXISTS `FICHIER` (
  `Fichier_Id` int(11) NOT NULL auto_increment,
  `Nom_fichier` varchar(60) NOT NULL default '',
  `Binaire` blob NOT NULL,
  `Date` date NOT NULL,
  `Commentaire` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`Fichier_Id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


--
-- Structure de la table `FILTRE`
--

DROP TABLE IF EXISTS `FILTRE`;
CREATE TABLE IF NOT EXISTS `FILTRE` (
  `Filtre_Id` int(11) NOT NULL auto_increment,
  `Module_Id` int(11) NOT NULL,
  `Colonne` varchar(30) NOT NULL,
  `Force` tinyint(1) NOT NULL,
  `Value` varchar(120) NOT NULL,
  PRIMARY KEY  (`Filtre_Id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



--
-- Structure de la table `IMPORT`
--

DROP TABLE IF EXISTS `IMPORT`;
CREATE TABLE IF NOT EXISTS `IMPORT` (
  `Import_Id` int(11) NOT NULL auto_increment,
  `Module_Id` int(11) NOT NULL,
  `Fichier_Id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`Import_Id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


--
-- Structure de la table `MODULE`
--

DROP TABLE IF EXISTS `MODULE`;
CREATE TABLE IF NOT EXISTS `MODULE` (
  `Module_Id` int(11) NOT NULL auto_increment,
  `Nom` varchar(12) NOT NULL,
  `Table` varchar(30) NOT NULL,
  `Lien` varchar(60) NOT NULL,
  `Etat` tinyint(1) NOT NULL default '1',
  `App_Id` int(11) NOT NULL,
  PRIMARY KEY  (`Module_Id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=8 ;


--
-- Structure de la table `MODULE_ACCESS`
--

DROP TABLE IF EXISTS `MODULE_ACCESS`;
CREATE TABLE IF NOT EXISTS `MODULE_ACCESS` (
  `User_Id` int(11) NOT NULL,
  `Module_Id` int(11) NOT NULL,
  `Position` int(11) NOT NULL,
  PRIMARY KEY  (`User_Id`,`Module_Id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Structure de la table `PATCH`
--

DROP TABLE IF EXISTS `PATCH`;
CREATE TABLE IF NOT EXISTS `PATCH` (
  `Patch_Id` int(11) NOT NULL auto_increment,
  `Version` varchar(10) NOT NULL,
  `Path` varchar(90) NOT NULL,
  PRIMARY KEY  (`Patch_Id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


--
-- Structure de la table `REGROUPE`
--

DROP TABLE IF EXISTS `REGROUPE`;
CREATE TABLE IF NOT EXISTS `REGROUPE` (
  `User_Id` int(11) NOT NULL,
  `Societe_Id` int(11) NOT NULL,
  PRIMARY KEY  (`User_Id`,`Societe_Id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


--
-- Structure de la table `ROLE`
--

DROP TABLE IF EXISTS `ROLE`;
CREATE TABLE IF NOT EXISTS `ROLE` (
  `Role_Id` int(11) NOT NULL auto_increment,
  `Nom` varchar(12) NOT NULL,
  PRIMARY KEY  (`Role_Id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=7 ;


--
-- Structure de la table `SCRIPT`
--

DROP TABLE IF EXISTS `SCRIPT`;
CREATE TABLE IF NOT EXISTS `SCRIPT` (
  `Script_Id` int(11) NOT NULL auto_increment,
  `Nom` varchar(60) NOT NULL,
  `Module_Id` int(11) NOT NULL,
  `Lien` varchar(120) NOT NULL,
  PRIMARY KEY  (`Script_Id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=7 ;


--
-- Structure de la table `SOCIETE`
--

DROP TABLE IF EXISTS `SOCIETE`;
CREATE TABLE IF NOT EXISTS `SOCIETE` (
  `Societe_Id` int(11) NOT NULL auto_increment,
  `Code` varchar(3) NOT NULL,
  `Nom` varchar(20) NOT NULL default '',
  `Sous_Titre` varchar(60) NOT NULL,
  `Type_2` varchar(20) default NULL,
  `Adresse` varchar(150) default NULL,
  `Cp` varchar(10) default NULL,
  `Ville` varchar(30) default NULL,
  `Telephone` varchar(12) default NULL,
  `Fax` varchar(12) default NULL,
  `Email` varchar(120) default NULL,
  `Web` varchar(150) default NULL,
  `SIRET` varchar(14) default NULL,
  `TVA_Intra` text,
  `Q4N4` varchar(14) default NULL,
  `TextComp` text,
  `Logo` varchar(120) default NULL,
  `Tampon` varchar(120) default NULL,
  PRIMARY KEY  (`Societe_Id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=3 ;


--
-- Structure de la table `VUE`
--

DROP TABLE IF EXISTS `VUE`;
CREATE TABLE IF NOT EXISTS `VUE` (
  `Vue_Id` int(11) NOT NULL auto_increment,
  `Nom` varchar(12) NOT NULL default '',
  `Module_Id` int(11) NOT NULL,
  `Rows` text NOT NULL,
  `Condition` text NOT NULL,
  `Defaut` tinyint(1) NOT NULL default '0',
  `Ordre` int(3) NOT NULL default '0',
  PRIMARY KEY  (`Vue_Id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=60 ;

--
-- Structure de la table `WORKFLOW`
--

DROP TABLE IF EXISTS `WORKFLOW`;
CREATE TABLE IF NOT EXISTS `WORKFLOW` (
  `Wordkflow_Id` int(11) NOT NULL auto_increment,
  `Module_Id` int(11) NOT NULL,
  `Objet_Id` int(11) NOT NULL,
  `Colonne` varchar(60) NOT NULL,
  `Valider` tinyint(1) NOT NULL,
  `Date` date NOT NULL,
  PRIMARY KEY  (`Wordkflow_Id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


