<?php
  /**
   * MiniClick
   * Gestionnaire de tableau collaboratif
   * Copyright (C) 2006 Guillaume Monet <gm@ibreizh.net>
   *
   * This program is free software; you can redistribute it and/or modify
   * it under the terms of the GNU General Public License as published by
   * the Free Software Foundation; either version 2 of the License, or
   * any later version.
   *
   * This program is distributed in the hope that it will be useful,
   * but WITHOUT ANY WARRANTY; without even the implied warranty of
   * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   * GNU General Public License for more details.
   *
   * You should have received a copy of the GNU General Public License
   * along with this program; if not, write to the Free Software
   * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA 
   *
   * @package miniclick
   * @version 5.0.0
   */

class db_interface {

  private $master;
  private $slave;

  private static $instance;

  private function __construct(){
		
  }

  public static function getInstance(){
    if (!isset(self::$instance)) {
      $c = __CLASS__;
      self::$instance = new $c;
      self::$instance->db_connect();
    }
    return self::$instance;
  }

  public function __clone(){
    trigger_error('Can\'t Clone Singleton Class ', E_USER_ERROR);
  }

  public function db_connect(){
    switch (DB_TYPE) {
    case "mysql":
      if(!$this->db_connected()){				
        $this->master = mysql_connect(DB_MASTER_HOST.":".DB_MASTER_PORT,DB_USER,DB_PASS) 
          or die("Impossible de se connecter au master : " . mysql_error() 
                 . "\n <br> Check connection IDs in includes/config.php");
        $this->slave = mysql_connect(DB_SLAVE_HOST.":".DB_SLAVE_PORT,DB_USER,DB_PASS)
          or die("Impossible de se connecter au master : " . mysql_error() 
                 . "\n <br> Check connection IDs in includes/config.php");
      }
      break;
    case "postgresql":
      $this->master = pg_connect("host=".DB_MASTER_HOST." port=".DB_MASTER_PORT." user=".DB_USER." password=".DB_PASS."");
      $this->slave = pg_connect("host=".DB_SLAVE_HOST." port=".DB_SLAVE_PORT." user=".DB_USER." password=".DB_PASS."");
      break;
    }
		
  }

  public function db_connected(){
    if($this->master && $this->slave){
      return true;
    }else{
      return false;
    }
  }

  public function db_select($database){
    switch (DB_TYPE) {
    case "mysql":
      mysql_select_db($database,$this->master);
      mysql_select_db($database,$this->slave);
      break;
    case "postgresql":
      break;
    }
  }

  public function db_query($query){
    //syslog(LOG_DEBUG,$query);
    switch (DB_TYPE) {
    case "mysql":
      $resource = mysql_query($query,$this->slave);
      if(!$resource){
        die("Erreur dans la requete : $query <br />".mysql_error($this->slave));
        return null;
      }
      return $resource;
      break;
    case "postgresql":
      break;
    }
  }

  public function db_update($update){
    switch (DB_TYPE) {
    case "mysql":
      return mysql_query($update,$this->master);
      break;
    case "postgresql":
      break;
    }
  }

  public function db_insert($insert){
    switch (DB_TYPE) {
    case "mysql":
      return mysql_query($insert,$this->master);
      break;
    case "postgresql":
      break;
    }
  }

  public function db_delete($insert){
    switch (DB_TYPE) {
    case "mysql":
      return mysql_query($insert,$this->master);
      break;
    case "postgresql":
      break;
    }
  }

  public function db_close(){
    switch (DB_TYPE) {
    case "mysql":
      mysql_close($this->master);
      mysql_close($this->slave);
      break;
    case "postgresql":
      break;
    }
  }

  public function db_fetch_object($resource){
    switch (DB_TYPE) {
    case "mysql":
      if($object = mysql_fetch_object($resource)){
        return $object;
      }
      break;
    case "postgresql":
      break;
    }
  }

  public function db_fetch_array($resource){
    switch (DB_TYPE) {
    case "mysql":
      if($array = mysql_fetch_array($resource)){
        return $array;
      }
      break;
    case "postgresql":
      break;
    }
  }

  public function db_num_rows($resource){
    switch (DB_TYPE) {
    case "mysql":
      return mysql_num_rows($resource);
      break;
    case "postgresql":
      break;
    }
	
  }
  }
?>
