<?php
/**
* MiniClick
* Gestionnaire de tableau collaboratif
* Copyright (C) 2006 Guillaume Monet <gm@ibreizh.net>
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA 
*
* @package miniclick
* @version 5.0.0
*/
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
  "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
  <head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8"/>
    <title>Localisation GPS</title>
    <script src="http://maps.google.com/maps?file=api&amp;v=2&amp;key=ABQIAAAAijLYGZEd0DGlk-UXAvsPMhT2yXp_ZAY8_ufC3CFXhHIE1NvwkxQgGK3dbR54Q-U5bleNffLtzaNJnA"
      type="text/javascript"></script>

<script type="text/javascript">
    //<![CDATA[

    var map;
    var gdir;
    var geocoder = null;
    var addressMarker;

	function load() {
		if (GBrowserIsCompatible()) {      
			map = new GMap2(document.getElementById("map"));
			map.addControl(new GSmallMapControl());
			map.addControl(new GMapTypeControl());
			gdir = new GDirections(map, document.getElementById("directions"));
			GEvent.addListener(gdir, "load", onGDirectionsLoad);
			GEvent.addListener(gdir, "error", handleErrors);
			setDirections("Vannes", "Vannes", "fr_FR");
		}
	}
	function setDirections(fromAddress, toAddress, locale) {
		gdir.load("from: " + fromAddress + " to: " + toAddress,{ "locale": locale });
	}

	function handleErrors(){
		if (gdir.getStatus().code == G_GEO_UNKNOWN_ADDRESS)
			alert("No corresponding geographic location could be found for one of the specified addresses. This may be due to the fact that the address is relatively new, or it may be incorrect.\nError code: " + gdir.getStatus().code);
		else if (gdir.getStatus().code == G_GEO_SERVER_ERROR)
			alert("A geocoding or directions request could not be successfully processed, yet the exact reason for the failure is not known.\n Error code: " + gdir.getStatus().code);	   
		else if (gdir.getStatus().code == G_GEO_MISSING_QUERY)
			alert("The HTTP q parameter was either missing or had no value. For geocoder requests, this means that an empty address was specified as input. For directions requests, this means that no query was specified in the input.\n Error code: " + gdir.getStatus().code);
		else if (gdir.getStatus().code == G_GEO_BAD_KEY)
			alert("The given key is either invalid or does not match the domain for which it was given. \n Error code: " + gdir.getStatus().code);
		else if (gdir.getStatus().code == G_GEO_BAD_REQUEST)
			alert("A directions request could not be successfully parsed.\n Error code: " + gdir.getStatus().code);	    
		else alert("An unknown error occurred.");
	}

	function onGDirectionsLoad(){ 
	}


    //]]>
    </script>
</head>
	<body onload="load()" onunload="GUnload()">
    <form action="#" onsubmit="setDirections(this.from.value, this.to.value,'fr_FR'); return false">

  <table>

   <tr><th align="right">De:&nbsp;</th>

   <td><input type="text" size="25" id="fromAddress" name="from"
     value=""/></td>
   <th align="right">&nbsp;&nbsp;A:&nbsp;</th>
   <td align="right"><input type="text" size="25" id="toAddress" name="to"
     value="" /></td></tr>

   <tr>
   <td colspan="3">

    <input name="submit" type="submit" value="Voir le trajet" />
   </td></tr>
   </table>

    
  </form>

    <br/>
    <table class="directions">

    <tr><th>Chemins a suivre</th><th>Map</th></tr>

    <tr>
    <td valign="top"><div id="directions" style="height: 400px; width: 275px;clip: rect(10px, 10px, 10px, 10px); overflow:auto;"></div></td>
    <td valign="top"><div id="map" style="width: 600px; height: 400px"></div></td>
    </tr>
    </table>    

    
  </body>

</html>
