<?php

/**
 * MiniClick
 * Gestionnaire de tableau collaboratif
 * Copyright (C) 2006 Jean-Claude Amiot <jeanc@mixid.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * @package miniclick
 * @version 5.0.0
 * @author Jean-Claude Amiot
 * @filesource engine/miniclic/user_class.php
 *
 */



class User
{
	var $infosUser ; // Objet avec les donnes utilisateurs
	var $listOfAppAccess ; // Tableau associatif contenant l'ensemble des applications auxquelles l'utilisateur  droit d'accs  
	var $listOfModuleAccess ; // Tableau associatif contenant l'ensemble des modules auxquels l'utilisateur  droit d'accs
	var $listOfSocieteAccess ; // Tableau associatif contenant l'ensemble des societes auxquels l'utilisateur  droit d'accs
	 
	var $db ;

	/**
	 * Constructeur de la classe User
	 *
	 * @param $userId , identifiant de l'utilisateur
	 * @return Nothing
	 * @author Jean-Claude Amiot
	 *
	 */

	function User($userId) {
		$this->db = db_interface::getInstance();
		$this->db->db_select(DB_NAME);
		$this->infosUser = $this->getUser($userId);
		$this->listOfAppAccess = $this->getListOfAppAccess() ;
		$this->listOfModuleAccess = $this->getListOfModuleAccess();
		$this->listOfSocieteAccess = $this->getSocieteAccess() ; 
	}

	/**
	 * Rcupre les informations utilisateur
	 *
	 * @param $userI , identifiant de l'utilisateur
	 * @return un objet contenant les informations utilisateur
	 *
	 */
	function getUser($userId) {
		if(!is_numeric($userId)) return false ;
		$r=$this->db->db_query("SELECT * FROM USER WHERE User_Id=".$userId) ;
		if($this->db->db_num_rows($r)) {
			return $this->db->db_fetch_object($r) ;
		}
		else {
			return false ;
		}
	}

	/**
	 * retourne un tableau de toutes les applications auxquelles l'utilisateur a droit
	 *
	 * @return $listOfAccess
	 */

	function getListOfAppAccess() {

		$listOfAccess = array();
		$r=$this->db->db_query("SELECT a.*,r.Nom as roleName FROM APP_ACCESS a, ROLE r WHERE r.Role_Id=a.Role_Id AND a.User_Id=".$this->infosUser->User_Id) ;
		while($v=$this->db->db_fetch_object($r)){
			$listOfAccess[$v->App_Id]=$v;
		}
		return $listOfAccess ;
	}

	/**
	 * Indique si l'utilisateur  le droit d'accs  l'application $appId
	 *
	 * @param $appId , identifiant de l'application
	 * @return true si l'utilisateur  un droit d'accs  cette application
	 */

	function isAppAccessAllowed($appId){
		return array_key_exists($appId,$this->listOfAppAccess);
	}

	/**
	 * Affecte un nouveau rle spcifi par $roleId , pour l'utisateur et l'application $appId
	 *
	 * @param int $appId , identifiant de l'application
	 * @param int $roleId , identifiant du rle de l'utilisateur pour cette application
	 * @param int $roleId
	 */

	function setAppRoleAccess($appId,$roleId) {

		if($roleId==0)
		{
			// Aucun rle slectionn
			if($this->isAppAccessAllowed($appId)) {
				// Un droit d'accs  cette aplpication existe, on la supprime
				$r=$this->db->db_query("DELETE FROM APP_ACCESS WHERE App_Id=$appId AND User_Id=".$this->infosUser->User_Id);
			}
		}
		elseif($this->listOfAppAccess[$appId]->Role_Id != $roleId)
		{
			// Un rle a t slectionn pour cette application et il est diffrent de celui en cours
			$table=array(
			"App_Id" => $appId,
			"User_Id" => $this->infosUser->User_Id,
			"Role_Id" => $roleId
			) ;

			if($this->isAppAccessAllowed($appId)) {
				// Un rle est dj dfini dans la base de donnes, on met  jour
				// On met  jour l'enregistrement
				$this->db->db_perform('APP_ACCESS',$table,'update',"App_Id=$appId AND User_Id=".$this->infosUser->User_Id) ;
			}
			else {
				// Aucun rle est dfini
				// On insre ce nouveau rle pour cette application
				$this->db->db_perform('APP_ACCESS',$table) ;
			}

		}
	}


	/**
	 * retourne un tableau de tous les modules auxquels l'utilisateur a droit
	 *
	 * @return $listOfModule
	 */

	function getListOfModuleAccess() {

		$listOfModule = array();
		$r=$this->db->db_query("SELECT m1.*,m2.App_Id FROM MODULE_ACCESS m1, MODULE m2 WHERE m1.Module_Id=m2.Module_Id AND m1.User_Id=".$this->infosUser->User_Id) ;
		while($v=$this->db->db_fetch_object($r)){
			$listOfModule[$v->Module_Id]=$v;
		}
		return $listOfModule ;
	}


	/**
	 * Indique si l'utilisateur  le droit d'accs au module $moduleId
	 *
	 * @param $moduleId , identifiant de l'application
	 * @return true si l'utilisateur  un droit d'accs  ce module
	 */

	function isModuleAccessAllowed($moduleId) {
		return array_key_exists($moduleId,$this->listOfModuleAccess);
	}

	
	/**
	 * Redfinit le droit d'accs de l'utilisateur  un module
	 *
	 * @param int $moduleId - identifiant du module
	 * @param int $active - 0 dsactive le module , 1 active le module
	 * @param int $position - dfinit le position du module
	 *
	 */


	function setModuleAccess($moduleId,$active,$position) {

		$activiteEnCours = $this->isModuleAccessAllowed($moduleId) ;
		if($activiteEnCours) {
			$positionEnCours = $this->listOfModuleAccess[$moduleId]->Position ;
		} else {
			$positionEnCours = 0 ;
		}


		if(!$active && $activiteEnCours) {
			// Le droit au module existe il faut le supprimer
			$this->db->db_query("DELETE FROM MODULE_ACCESS WHERE Module_Id=$moduleId AND User_Id=".$this->infosUser->User_Id);

		}

		if($active && !$activiteEnCours) {
			// Il n'esiste de droit d'accs au module il faut le crer
			$table=array(
			"Module_Id" => $moduleId,
			"User_Id" => $this->infosUser->User_Id,
			"position" => $position
			) ;

			$this->db->db_perform('MODULE_ACCESS',$table) ;

		}

		if($active && $activiteEnCours && $position!=$positionEnCours ) {
			// La position a chang il faut la mettre  jour
			$table=array(
			"position" => $position
			) ;
			$this->db->db_perform('MODULE_ACCESS',$table,'update',"Module_Id=$moduleId AND User_Id=".$this->infosUser->User_Id) ;

		}
	}

	
	/**
	 * retourne un tableau de toutes les socits auxquelles l'utilisateur a droit
	 *
	 * @return $listOfSociete
	 * 
	 */	
	
	function getSocieteAccess() {
		$listOfSociete = array();
		$r=$this->db->db_query("SELECT s.* FROM REGROUPE r,SOCIETE s WHERE s.Societe_Id=r.Societe_Id AND r.User_Id=".$this->infosUser->User_Id) ;
		while($v=$this->db->db_fetch_object($r)){
			$listOfSociete[$v->Societe_Id]=$v;
			}
		return $listOfSociete ;		
		}


	/**
	 * Indique si l'utilisateur  le droit d'accs  la socit $societeId
	 *
	 * @param $societeId , identifiant de l'application
	 * @return true si l'utilisateur  un droit d'accs  la socit
	 */		

		
	function isSocieteAccessAllowed($societeId) {
		return array_key_exists($societeId,$this->listOfSocieteAccess);
		}	
		

	/**
	 * Redfinit le droit d'accs de l'utilisateur  une societe
	 *
	 * @param int $moduleId - identifiant du module
	 * @param int $active - 0 dsactive le module , 1 active le module
	 *
	 */	
	
	function setSocieteAccess($societeId,$active)
		{

		$activeEnCours = $this->isSocieteAccessAllowed($societeId) ;

		if($active==0 && $activeEnCours) {
			// Le droit  la socit existe il faut le supprimer
			//echo "supression $active - $societeId - pour ".$this->infosUser->User_Id."<br>\n" ;
			$this->db->db_query("DELETE FROM REGROUPE WHERE Societe_Id='$societeId' AND User_Id=".$this->infosUser->User_Id);
			}

		

		if($active && !$activeEnCours) {
			// Il n'esiste de droit d'accs  la socit il faut le crer
			
			//echo "Ajouter $active - $activeEnCours -  $societeId - pour ".$this->infosUser->User_Id."<br>\n" ;
			
			$table=array(
			"Societe_Id" => $societeId,
			"User_Id" => $this->infosUser->User_Id
			) ;
			$this->db->db_perform('REGROUPE',$table) ;
			
			}
		}
	
	
}

?>