<?php
/**
* MiniClick
* Gestionnaire de tableau collaboratif
* Copyright (C) 2006 Guillaume Monet <gm@ibreizh.net>
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA 
*
* @package miniclick
* @version 5.0.0
*/

function Majuscules($Chaine){
         $Chaine=Strtr($Chaine,"ÀÁÂÃÄÅÇÈÉÊËÌÍÎÏÒÓÔÕÖÝÙÚÛÜàáâãäåçèéêëìíîïðòóôõöùúûüýÿ","AAAAAACEEEEIIIIOOOOOYUUUUaaaaaaceeeeiiiioooooouuuuyy");
         $Chaine=strtoupper($Chaine);
         return $Chaine;
}

function Chainepropre($Chaine){

         $Chaine=Majuscules($Chaine);
         //cas particuliers " " et decimaux
         preg_match("/\".*\"/",$Chaine,$MotsGuill);
         ForEach($MotsGuill as $v)
         {
                 //on efface le mots entre guillements
                 $Chaine=str_replace($v," ",$Chaine);
         }

         preg_match("/[0-9]+\.[0-9]+/",$Chaine,$Decim);
         ForEach($Decim as $v)
         {
                 //on efface les decimaux
                 $Chaine=str_replace($v," ",$Chaine);
         }

         // on recup les chaines
         $Mots=preg_split("/[^a-zA-Z]+/",$Chaine);
         //on garde les mots d'au moins un caractère
         $MotsLettres=preg_grep("/[a-zA-Z][a-zA-Z]+/",$Mots);

         //on recup les chiffres
         $Mots=preg_split("/[^0-9]+/",$Chaine);
         $MotsChiffres=preg_grep("/[0-9][0-9]+/",$Mots);

         //on rassemble tout les tableaux selectionnés
         $TabMots=array_merge($MotsGuill,$MotsLettres,$MotsChiffres,$Decim);
         $Tab=array_unique($TabMots);

         $MotsVides=array(" ","LE","LA","LES","DE","DU","DANS","DES","MAIS","OU","EST","DONC","OR","NI","CAR","JE","TU","IL","ELLE","NOUS","VOUS","ILS","ELLES","EUX","CE","CEUX","CELUI","CELLE","CELA","CECI","TOUS","TOUT","SE","PAS","TRES","SUR","SOUS","EN","MON","TON","SON","MA","TA","SA","MES","TES","SES","UN","UNE","POUR","COMME","AVEC","NON","NE","-");
         $Tab=array_diff($Tab,$MotsVides);

         $Tab=array_values($Tab);
         return $Tab;
}

foreach(Chainepropre("st-jacques-de-la-lande") as $mot){
	echo $mot;
}

?>