<?php
/**
 * MiniClick
 * Gestionnaire de tableau collaboratif
 * Copyright (C) 2006 Guillaume Monet <gm@ibreizh.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * @package miniclick
 * @version 5.0.0
 * @author Guillaume Monet
 * @author Jean-claude Amiot
 */

//Test de l'appel par le main ou un descendant
if($GLOBALS['main'] != 1)
{
	die("Cannot acces directly to this page");
}

//define_syslog_variables();

class miniclick{

	var $module_id;
	var $table;

	var $smarty;

	var $headers;
	var $labels;
	var $types;
	var $values;
	var $defauts;
	var $sizes;
	var $displays;
	var $totaux;
	var $workflows;
	var $read_perm;
	var $write_perm;
	var $mouseover;
	var $key;

	var $nb_headers;

	var $simple_query;
	var $query;
	var $mini_query;
	var $no_limit_query;
	var $select;
	var $where;
	var $whereImpose ; // instruction dans WHERE impos
	var $having;

	var $current_page;
	var $vue_condition;
	var $vue_rows;
	
	var $vue_tri ; // Tri personalis paramtr dans la table VUE champs Tri 
	
	var $max_elems;
	var $count;
	var $db;

	var $tablesOfBase ;
	var $navBarrePage ;

	var $selectionCaddie;	
	var $gestionCaddie ;

	var $actionControl ;


	/**
	 * Constructeur de la classe Miniclick
	 * @param $table la table à afficher
	 * @see "Uses of MiniClick docs"
	 */
	function miniclick($table,$parameters=array())
	{
		$this->db = db_interface::getInstance();
		$this->db->db_select(DB_NAME);


		// Calcul du temps d'execution du programme
		$debut = $this->debut_calcultemps();

		if(is_array($parameters))
		{
		$this->whereImpose = $parameters['whereImpose'] ;	
		}

		// Rechercher dans la table module l'identifiant du module et le nom de la table  traiter
		$module_query = "SELECT * FROM MODULE WHERE `Table`='".$table."' AND App_Id='".$_SESSION['app_id']."'";
		
		$modules = $this->db->db_query($module_query);

		// Vrifier si le module existe
		if(!$this->db->db_num_rows($modules))
		{
			echo "Erreur2 : Le module portant le Nom <b>".$table."</b> pour l'application N ".$_SESSION['app_id']." n'a pas t trouv." ;
			return false ;
		}

		$module = $this->db->db_fetch_object($modules);
		$this->module_id = $module->Module_Id;
		$this->table = $module->Table;
		$this->gestionCaddie = $module->Caddie;
		if($this->gestionCaddie!=1 || $_GET['vue'])
			{
			$_GET['showCaddie']=0 ;
			}

		// Rcuprer toutes les tables prsentes dans la base de donnes
		$this->db->db_select($_SESSION['current_db']);

		$this->tablesOfBase = $this->getTableOfBase();



		$this->db->db_select(DB_NAME);
		// Vrifier si la table existe
		if(!in_array($this->table,$this->tablesOfBase))
		{
			echo "Erreur : La table ".$this->table." n'exite pas pour le module N ".$this->module_id." dans l'application N'".$_SESSION['app_id'] ;
			return false ;
		}


		$pathToActionControl = MINICLICK_INSTALL_PATH.'apps/'.$_SESSION['app_name'].'/modules/'.dirname($module->Lien).'/actionControl.class.php' ;
		if (file_exists($pathToActionControl)) {
			require($pathToActionControl);
			if (class_exists('actionControl')) {
				$this->actionControl = new ActionControl() ;
				}
			}

		$this->db->db_select(DB_NAME);
		$this->current_page = stripcslashes($_SERVER["REQUEST_URI"]);
		$sql_query = "SELECT DISTINCT "
		." CONFIG.mouseover,CONFIG.Colonne,Label,Type,IsKey,Value,"
		."Defaut,Size,Afficher,Total,Wf,Read_Perm,Write_Perm "
		." FROM CONFIG,DROIT WHERE CONFIG.Module_Id='"
		.$this->module_id."' AND DROIT.Module_Id='"
		.$this->module_id."' AND DROIT.Role_Id='".$_SESSION['role_id']
		."' AND CONFIG.Colonne = DROIT.Colonne ORDER BY Position";
		
		
		
		$configs = $this->db->db_query($sql_query);
		
		if($this->db->db_num_rows($configs) == 0)
		{
			if($_SESSION['role_id']==1)
			{
				// initialise les tables CONFIG et DROIT que pour les administrateurs
				$this->generate_defaut_config();
				$configs = $this->db->db_query($sql_query); // relance la requte
			}
			else
			{
				echo("<br><br>Aucun droit dfini pour ce module, role_id : ".$_SESSION['role_id']."<br><br>") ;
				return(false);
			}
		}


		$this->key = "";

		$this->headers = array();
		$this->labels = array();
		$this->types = array();
		$this->values = array();
		$this->defauts = array();
		$this->sizes = array();
		$this->displays = array();
		$this->totaux = array();
		$this->workflows = array();
		$this->read_perm = array();
		$this->write_perm = array();
		$this->keyPressCustom = array();
		$this->mouseover = array();
		$this->smarty = new Smarty();
		$this->smarty->template_dir = SMARTY_TEMPLATE_DIR;
		$this->smarty->compile_dir = SMARTY_COMPILE_DIR;
		$this->smarty->config_dir = SMARTY_CONFIG_DIR;
		$this->smarty->cache_dir = SMARTY_CACHE_DIR;
		$this->generate_views();
		$shown = explode(",",$this->vue_rows);







		while($config = $this->db->db_fetch_object($configs))
		{

			if(($config->Afficher == 1
			&& ($this->vue_rows == "*" || in_array($config->Colonne,$shown)))
			|| $config->IsKey == "1")
			{

				
				if($config->IsKey == "1")
				{
					$this->key =  $config->Colonne;
				}
				$this->nb_headers++;
				
				if($config->Type=='INPUT2')
					{
					$config->Type='INPUT' ;
					array_push($this->keyPressCustom,'Yes') ;
					}
				else
					{
					array_push($this->keyPressCustom,'No') ;
					}				
				
				array_push ($this->headers,$config->Colonne);
				array_push ($this->labels,$config->Label);
				array_push ($this->types,$config->Type);
				array_push ($this->values,$config->Value);
				array_push ($this->defauts,$config->Defaut);
				array_push ($this->sizes,$config->Size);
				array_push ($this->displays,$config->Afficher);
				array_push ($this->totaux,$config->Total);
				array_push ($this->workflows,$config->Wf);
				array_push ($this->read_perm,$config->Read_Perm);
				array_push ($this->write_perm,$config->Write_Perm);
				array_push ($this->mouseover,$config->mouseover);
			}
		}

		// Vrifier si l'on est en mode fiche
		if( is_numeric($_GET['enr_id']) )
			{
			//echo $this->key ;
			if($this->whereImpose)
				{
				$this->whereImpose .= 'AND '.$this->key.'='.$_GET['enr_id'].' ' ;
				}
			else
				{
				$this->whereImpose = $this->key.'='.$_GET['enr_id'].' ' ;
				}
			}

		if($this->gestionCaddie==1)
			{
			$this->getElementInCaddie();
			}

		if($_GET['showCaddie']=='1')
			{
			$this->affecteCaddie();
			}

		$this->smarty->assign('gestionCaddie',$this->gestionCaddie) ;
		$this->smarty->assign('showCaddie',$_GET['showCaddie']) ;
		
		// Vrification si il existe au moins un droit sur les champs de la table pour l'utilisateur en cours
		$sumOfPerm = 0 ;
		foreach($this->read_perm as $key => $value)
		{
			$sumOfPerm = $sumOfPerm+$this->read_perm[$key]+$this->write_perm[$key]+$this->workflows[$keys] ;
		}

		if($sumOfPerm == 0)
		{
			echo("<br><br>Aucun droit dfini pour ce module, role_id : ".$_SESSION['role_id']."<br><br>") ;
			return(false);
		}

		$this->smarty->assign('form_action',htmlentities($this->current_page));

		$scripts = $this->db->db_query("SELECT * FROM SCRIPT WHERE Module_Id='".$this->module_id."'");
		$ret_scripts = array();
		while($script = $this->db->db_fetch_object($scripts))
		{
			array_push($ret_scripts, array('nom'=>$script->Description,'lien'=>$script->Lien));
		}

		$this->smarty->assign('scripts', (sizeof($ret_scripts)>0)?$ret_scripts:'none' ) ;


		
		$this->db->db_select($_SESSION['database']);
		$this->generate_request();
		

		if($_POST['action'] != "")
		    {
		    $this->do_action($_POST['action']);
		    }
		
		if($_GET['module_id']==19 || $_GET['module_id']==13 )
		    {
		    $customInput=$this->no_limit_query.substr( md5($this->no_limit_query) ,0 , 4 ) ;
		    $this->smarty->assign('customInput',urlencode($customInput));
		    }
		
		
		$this->generate_headers();

		$this->generate_datas();
		$this->generate_totals();
		$this->generate_tools();
		$this->generate_pages();
		$this->smarty->assign('template_dir_images',SMARTY_IMAGE_DIR_APP);
		
		$this->smarty->assign('table',$this->table);


		if(!is_numeric($_GET[enr_id]))
			{
			$this->smarty->display('miniclick/miniclick.tpl');
			}
		else
			{
			$this->smarty->display('miniclick/fiche_miniclick.tpl');
			}


		//echo '<br>temps '.$this->ecrire_temps($debut,10).' s';
		// valeur globale rcupre dans le template

		$_GET['tempsClassMiniclick']=$this->ecrire_temps($debut,10) ;
	}
//
	function generate_defaut_config()
	{
		$ressource = $this->db->db_query("SELECT * FROM CONFIG WHERE Module_Id='".$this->module_id."'");
		if($this->db->db_num_rows($ressource)==0)
		{

			//echo '>>>>'.$this->table.'<<<<' ;
			
			$fields = $this->db->db_query("DESCRIBE ".$_SESSION['database'].".".$this->table);
			$pos = 0;
			$key = "";
			while($field = $this->db->db_fetch_object($fields))
			{
				
				$dataToInsert = array (
				'Module_Id' => $this->module_id ,
				'Colonne' => $field->Field ,
				'Position' => $pos++ ,
				'IsKey'=> ($field->Key == "PRI")?1:0, 
				'Type' => 'INPUT',
				'Size' => 10 ,
				'Total' => 0 ,
				'Wf' => 0 ,
				'Afficher' => 1,
				'Label' => $field->Field
				) ;
				
				$this->db->db_perform('CONFIG',$dataToInsert);
				/*
				$pos++;
				if($field->Key == "PRI")
				{
					$key = "1";
				}else{
					$key = "0";
				}
				$insert_config="INSERT INTO CONFIG  VALUES('','"
				.$this->module_id."','"
				.$field->Field."','$pos','$key','INPUT','','10','0','0','','1','"
				.$field->Field."')";
				$this->db->db_query($insert_config);
				*/
			}
		}
		else
		{
			echo "Des champs sont dj prdfinis pour le module ".$this->module_id ;
		}


		$ressource = $this->db->db_query("SELECT * FROM DROIT WHERE Module_Id='".$this->module_id."'");

		if($this->db->db_num_rows($ressource)==0)
		{
			$listOfFields = array();
			echo "Aucun droit dfinis, on regarde pour en crer" ;
			$ressource = $this->db->db_query("SELECT * FROM CONFIG WHERE Module_Id='".$this->module_id."'");
			while($field = $this->db->db_fetch_object($ressource))
			{
				// Eviter les doublons
				if(!in_array($field->Colonne,$listOfFields))
				{
					$listOfFlieds[]=$field->Colonne ;

					$table = array (
				"Module_Id" => $this->module_id ,
				"Colonne" => $field->Colonne ,
				"Role_Id" => 1,
				"Read_Perm" => 1 ,
				"Write_Perm" => 1 ,
				"Workflow_Perm" => 1
					);

					$this->db->db_perform('DROIT',$table) ;

				}
				else
				{
					echo 'Duplication du champs Colonne : '.$field->Colonne.' dans la table CONFIG pour le module N'.$this->module_id." Application N".$_SESSION['app_id']." id=".$field->Config_Id."<br>" ;
				}

			}

		}



	}

	function generate_views()
	{

		
		$views = array();
		$sql_query = "SELECT `fiche`,`Societe_vue`,`Vue_Id`,`Tri`,`Nom`,`Module_Id`,`Rows`,`Condition`,`Defaut` FROM VUE WHERE Module_Id='"
		.$this->module_id."' ORDER BY `Ordre`";
		$vues = $this->db->db_query($sql_query) ;
		if($this->db->db_num_rows($vues) == 0)
		{
			$this->generate_defaut_view();
		}
		
		
		/*
		while($vue = $this->db->db_fetch_object($vues))
		{
			$actif = 0;
			if($_GET['vue'] == $vue->Vue_Id || ($_GET['vue'] == "" && $vue->Defaut=="1"))
			{
				$actif = 1;
				$this->vue_condition = $vue->Condition;
				$this->vue_rows=$vue->Rows;
				$this->vue_tri=$vue->Tri ;
			}
			array_push($views,array('nom'=>$vue->Nom,'lien'=>htmlentities($this->current_page)
			."&amp;vue=$vue->Vue_Id"."&amp;$vue->Condition",'actif'=>"$actif" ));
		}
		*/
		
		$url=parse_url($this->current_page);
		$queryUrl=array();
		//print_r($url) ;	
		$tab=explode("&",$url['query']) ;
		//print_r($tab) ;
		foreach($tab as $key => $value)
		{
			$argument=explode("=",$value) ;
			if(sizeof($argument)==2 && $argument[0]!='vue')
			{
				$queryUrl[$argument[0]]=$argument[1] ;
			}
		}
		
		$chemin = $url['path'].'?'.http_build_query($queryUrl) ;

		
		$nbFiche=0;

			while($vue = mysql_fetch_object($vues))
			{
			$actif = 0;
			if( $vue->Societe_vue=='' || (strtolower($_SESSION['societe'])==strtolower($vue->Societe_vue)) )
				{
				if($_GET['vue'] == $vue->Vue_Id || ($_GET['vue'] == "" && $vue->Defaut=="1"))
					{
					$actif = 1;
					$this->vue_condition = $vue->Condition;
					$this->vue_rows=$vue->Rows;
					$this->vue_tri=$vue->Tri ;
					}
					
				if($vue->fiche==1)
					{
					$nbFiche++;
					}

			
				if($this->gestionCaddie==1 && $_GET['showCaddie']==1)
					{
					$actif = 0;
					}

				array_push($views,array('fiche'=>$vue->fiche,'id'=>$vue->Vue_Id,'nom'=>$vue->Nom,'lien'=>$chemin."&vue=$vue->Vue_Id",'actif'=>"$actif" ));	
				}
			}

		if($this->gestionCaddie==1)
			{
			$pathToCaddie='main.php?module_id='.$this->module_id.'&showCaddie=1' ;
			$actif=($_GET['showCaddie']==1)?1:0;
			array_push($views,array('fiche'=>0,'id'=>'','nom'=>'Caddie','lien'=>$pathToCaddie,'actif'=>$actif ));	
			}


		$this->smarty->assign('nbfiche',$nbFiche);
		$this->smarty->assign('views',$views);
	}

	function generate_defaut_view()
	{
	$dataToInsert = array (
		'Nom' => 'Tout',		
		'Module_Id' => $this->module_id ,
		'Rows' => '*' ,
		'Defaut'=> 1, 
		'Ordre' => 1
		) ;
	$this->db->db_perform('VUE',$dataToInsert);
	//	$this->db->db_query("INSERT INTO VUE VALUES('','Tout','".$this->module_id."','*','','1','1')");
	}

	function generate_request()
	{
		$query = "";
		$select = "";
		$where = "";
		$having = "";
		$order = "";

		$mini_query ="";
		$mini_select = "";
		$mini_where = "";
		$mini_having = "";
		$key = $this->key;


		$vue_condition_regxp='';
		if(strripos($this->vue_condition,'REGEXP(')!==false)
			{
			$vue_condition_regxp=$this->vue_condition;
			$this->vue_condition='';
			}

		if($this->vue_condition != "")
		{
			if($_GET['where'] != "")
			{
				$_GET['where'] .= " AND ".$this->vue_condition;
			}else{
				$_GET['where'] = " ".$this->vue_condition;
			}
		}
		$_GET['where'] = stripslashes($_GET['where']);




		$cwhere = explode(" AND ",$_GET['where']);
		if(strlen($_GET['where']) > 0)
			{
			foreach($cwhere as $clause)
				{
					
				$cl = explode("=",$clause);
				if( sizeof($cl)==2 )
					{
					$operateurSql='=' ;
					}

				if($operateurSql=='')
					{
					$cl = explode("<>",$clause);
					if( sizeof($cl)==2 )
						{
						$operateurSql='<>' ;
						}
					}

				if($operateurSql=='')
					{
					$cl = explode(">",$clause);
					if( sizeof($cl)==2 )
						{
						$operateurSql='>' ;
						}
					}

				if($operateurSql=='')
					{
					$cl = explode("<",$clause);
					if( sizeof($cl)==2 )
						{
						$operateurSql='<' ;
						}
					}


				$c_id = stripslashes($cl[0]);
				$c_value = stripslashes($cl[1]);
				$c_value =  str_replace("'","",$c_value);
				$c_id = trim($c_id);

				if(isset($_POST[$c_id]) || in_array($c_id,$this->headers)){
					if($operateurSql=='=') {$operateurSql='';}
					$_POST[$c_id] = $operateurSql.$c_value ;
				}else{
					$where .= "$c_id = '$c_value' AND ";
					$_POST[$c_id] = $c_value;
				}
				
				if($_GET['debugajc']==1)
					{
					echo "*".$c_id."* - *".$c_value."* Oprateur ".$operateurSql." Clause :".$clause.' $_POST :'.$_POST[$c_id].'<br>' ;
					}

			}			
			
			
			
			
			/*
			
			
			foreach($cwhere as $clause)
			{
				$cl = explode("=",$clause);
				$c_id = stripslashes($cl[0]);
				$c_value = stripslashes($cl[1]);
				$c_value =  str_replace("'","",$c_value);
				if(isset($_POST[$c_id]) || in_array($c_id,$this->headers))
				{
					$_POST[$c_id] = $c_value;
				}else{
					$where .= "$c_id = '$c_value' AND ";
					$_POST[$c_id] = $c_value;
				}
			}*/
		}
		
		
		if($this->whereImpose)
			{
				if($where)
				{
				$where = $this->whereImpose." AND $where" ;
				}
				else
				{
				$where = $this->whereImpose." AND " ;	
				}
			}

		if($vue_condition_regxp)
			{
				if($where)
				{
				$where = $vue_condition_regxp." AND $where" ;
				}
				else
				{
				$where = $vue_condition_regxp." AND " ;	
				}
			}


		
		$mini_where = $where;

		//echo $mini_where ;
		
		for($i = 0 ; $i < $this->nb_headers ; $i++)
		{
			$value = $this->headers[$i];
			$label = $this->labels[$i];
			$select .= "`".$value."`";
			$mini_select .= "`".$value."`";
			if ($_POST[$value] != "" && $_POST[$value] != $label) {

				if(($_POST[$value]{0} == "=" || $_POST[$value]{0} == ">" || $_POST[$value]{0} == "<" ) && is_numeric(substr($_POST[$value],1)))
					{

						
					$where .= "$value ".$_POST[$value]." AND ";
					$mini_where .=  "$value ".$_POST[$value]." AND ";
					
					
					}
					
				elseif($_POST[$value]{0} == "$")
					{
					// recherche par une expression rgulire
					$expressionReguliere = substr($_POST[$value],1); // enlever le premier caractre $
					$expressionReguliere = str_replace('"','',$expressionReguliere) ;
					$clauseExpressionReguliere = sprintf('%s REGEXP("%s")',$value,$expressionReguliere);
					$where .=  $clauseExpressionReguliere ;
					$mini_where .=  $clauseExpressionReguliere ;
					
					if($where != ""){
								$where .= " AND ";
								$mini_where .= " AND ";
							}
					}
				
				else{
					if($this->types[$i] == "RECHERCHE"
					|| $this->types[$i] == "LINKED"
					|| $this->types[$i] == "COMPLETION")
					{
						if(strstr($_POST[$value],'_'))
						{
							$having .= "(LINKED_".$value." like '".$_POST[$value]
							."' OR   '$_POST[$value]' LIKE REPLACE(LINKED_".$value.",'%',''))";
							$mini_having .= "(LINKED_".$value." like '".$_POST[$value]
							."' OR   '$_POST[$value]' LIKE REPLACE(LINKED_".$value.",'%',''))";
						}else{
							$having .= "(LINKED_".$value." LIKE '%".$_POST[$value]
							."%' OR '$_POST[$value]' like REPLACE(LINKED_".$value.",'%',''))";
							$mini_having .= "(LINKED_".$value." LIKE '%".$_POST[$value]
							."%' OR '$_POST[$value]' like REPLACE(LINKED_".$value.",'%',''))";
						}
						if($having != "")
						{
							$having .= " AND ";
							$mini_having .= " AND ";
						}
					}else{
						if(strstr($_POST[$value],'_'))
						{
							$where .= "($value like '$_POST[$value]' OR '".$_POST[$value]."' like REPLACE($value,'%',''))";
							$mini_where .= "($value like '$_POST[$value]' OR '".$_POST[$value]."' like REPLACE($value,'%',''))";

						}else{
							$where .= "($value like '%$_POST[$value]%' OR '".$_POST[$value]."' like REPLACE($value,'%',''))";
							$mini_where .= "($value like '%$_POST[$value]%' OR '".$_POST[$value]."' like REPLACE($value,'%',''))";
						}
						if($where != "")
						{
							$where .= " AND ";
							$mini_where .= " AND ";
						}

					}
				}
			}
			if($this->types[$i] == "RECHERCHE"
			|| $this->types[$i] == "LINKED"
			|| $this->types[$i] == "COMPLETION")
			{
				$vars = explode(",",$this->values[$i]);
				if(count($vars) > 1)
				{
					$select.=",(SELECT `".$vars[0]."` FROM ".$this->defauts[$i]." WHERE "
					.$this->defauts[$i].".".$vars[1]."=".$this->table.".".$vars[1].") AS LINKED_".$this->headers[$i];
					$mini_select.=",(SELECT `".$vars[0]."` FROM ".$this->defauts[$i]." WHERE "
					.$this->defauts[$i].".".$vars[1]."=".$this->table.".".$vars[1].") AS LINKED_".$this->headers[$i];
				}else{
					$select.=",(SELECT `".$this->values[$i]."` FROM ".$this->defauts[$i]." WHERE "
					.$this->defauts[$i].".".$this->headers[$i]."=".$this->table."."
					.$this->headers[$i].") AS LINKED_".$this->headers[$i];
					$mini_select.=",(SELECT `".$this->values[$i]."` FROM ".$this->defauts[$i]." WHERE "
					.$this->defauts[$i].".".$this->headers[$i]."=".$this->table."."
					.$this->headers[$i].") AS LINKED_".$this->headers[$i];
				}

			}

			if($this->types[$i] == "SUM")
			{
				// $select.=",(SELECT ".str_replace(",","+",$this->values[$i])." FROM ".$this->table." WHERE "
				// .$this->table.".".$key."=".$this->table.".".$key.") AS SUM_".$this->headers[$i];
				// $mini_select.=",(SELECT ".str_replace(",","+",$this->values[$i])." FROM ".$this->table
				// ." WHERE ".$this->table.".".$key."=".$this->table.".".$key.") AS SUM_".$this->headers[$i];
			}
			$dbname=DB_NAME;
			if($this->workflows[$i] == "1")
			{
				$select.=",(SELECT Valider FROM $dbname.WORKFLOW WHERE $dbname.WORKFLOW.Objet_Id="
				.$this->module_id." AND $dbname.WORKFLOW.Colonne = '$value' AND $dbname.WORKFLOW.Module_Id='"
				.$this->module_id."' LIMIT 1) AS AWF_$value";
				$select.=",(SELECT $dbname.DROIT.Workflow_Perm FROM $dbname.DROIT WHERE $dbname.DROIT.Colonne = '$value' AND $dbname.DROIT.Module_Id='"
				.$this->module_id."' AND $dbname.DROIT.Role_Id='".$_SESSION['role_id']."' LIMIT 1) AS DWF_$value";
			}

			if($this->nb_headers != $i+1)
			{
				$select .= ",";
				$mini_select .=",";
			}
		}
		if(substr($where,-5) == " AND ")
		{
			$where = substr($where,0,strlen($where)-5);
			$mini_where = substr($mini_where,0,strlen($mini_where)-5);
		}
		if(substr($having,-5) == " AND ")
		{
			$having = substr($having,0,strlen($having)-5);
			$mini_having = substr($mini_having,0,strlen($mini_having)-5);
		}

		if($_POST['sort'] != "")
		{
			$order = " ORDER BY $_POST[sort] $_POST[order]";
		}

		
		
		if($_POST['sort'] != ""){
			$order = " ORDER BY $_POST[sort] $_POST[order]";
		}
		elseif($this->vue_tri){
			$order = $this->getOrderFromVue() ;
		}
		
		
		
		
		if($having != "")
		{
			$having = "HAVING ".$having;
			$mini_having = "HAVING ".$mini_having;
		}
		// On genere la requete sql
		$count = "";
		if($where == "")
		{
			// BUG: $select is set but empty!
			$query = "SELECT $select FROM ".$this->table." $having $order";
			$mini_query = "SELECT $mini_select FROM ".$this->table." $mini_having $order";
		}
		else
		{
			//print "WHERE pas vide";
			$query = "SELECT $select FROM ".$this->table." WHERE $where  $having $order";
			$mini_query = "SELECT $mini_select FROM ".$this->table." WHERE $mini_where  $mini_having $order";
		}
		$this->query =$query;
		$this->select = $select;
		$this->where = $where;
		$this->having = $having;
		$page = $_POST['page'];


		
		if($_POST['page']<1)
			{
			$_POST['page']=0;
			}

		$page = $_POST['page'];

		if($page==""){
			$page = 0;
		}

		// Rechercher le nombre d'enregistrements
		// Repositionne la page  0 si index page trop grand

		
		$sql_datas = mysql_query("SELECT COUNT(".$this->key.") AS total FROM (".$mini_query.") AS tempo") ;
		
		/*
		echo "SELECT COUNT(".$this->key.") AS total FROM (".$mini_query.") AS tempo" ;
		exit();
		*/
		
		$elems = mysql_fetch_array($sql_datas);
		if($page)
			{
			if($page>$elems[total])
				{
				$_POST['page']=floor($elems[total]/MINICLICK_MAX_ROW_DISPLAY)*MINICLICK_MAX_ROW_DISPLAY ;
				$page=$_POST['page'];
				}
			}
		
		
		
		$this->no_limit_query = $this->query;
		
		//echo "<br>".$this->query."<br>";
		
		$this->mini_query = $mini_query;
		$this->query .= " LIMIT $page,".MINICLICK_MAX_ROW_DISPLAY;
	}

	function generate_pages()
	{
		$page = $_POST['page'];
		if($page=="")
		{
			$page = 0;
		}
		$this->smarty->assign('sort',$_POST['sort']);
		$this->smarty->assign('order',$_POST['order']);
		$this->smarty->assign('sort',$_POST['sort']);
		$this->smarty->assign('module_id',$this->module_id);
		$this->smarty->assign('page_minus',$page-MINICLICK_MAX_ROW_DISPLAY);
		$this->smarty->assign('page_plus',$page+MINICLICK_MAX_ROW_DISPLAY);
		$this->smarty->assign('page_max_minus',$this->max_elems-MINICLICK_MAX_ROW_DISPLAY);
		$this->smarty->assign('page_current',$page);
		
		
		// Calcul de la barre de navigation des pages en bas	
		include(MINICLICK_INSTALL_PATH."includes/utils/page/class.output_nav.php") ;
		$navigation = array(
			'sKey' => $sKey, // page handler
			'iRowT' => $this->max_elems,
			'iRowL' => MINICLICK_MAX_ROW_DISPLAY,
			'iPageL' => 10,
			'iPageC' => ($page/MINICLICK_MAX_ROW_DISPLAY)+1,
			'sQuery' => 'javascript:document.getElementById("page").value="@@@";document.getElementById("form_header").submit();',  // without page handler
			'sNoRes' => $sNoRes,
			'sCss' => 'numberpage',
			'sCss2' => 'page'
			);
	
		
			$PageObj = new OutputNavigator( $navigation );
			$this->navBarrePage = $PageObj->getNavBar();
			//echo $this->navBarrePage ;
			
			$this->navBarrePage .= '<input type="text" style="border: 1px solid #CCCCCC;" name="page2" id="page2" size="5">' ;			
			$this->navBarrePage .= '<input value="Ok" type="button" onClick=\'javascript:document.getElementById("page").value='.MINICLICK_MAX_ROW_DISPLAY.'*(document.getElementById("page2").value-1);document.getElementById("form_header").submit();\'' ;

			$this->smarty->assign('navigpagebarre',$this->navBarrePage);
		// Fin Calcul de la barre de navigation
		
		
		
	}

	function generate_headers()
	{

		$headers = array();
		for($i = 0 ; $i < $this->nb_headers ; $i++)
		{
			$tphead = $this->headers[$i];
			$tplabel = $this->labels[$i];
			$text = "";
			$class = "0";
			if ($_POST[$tphead] !="" && $_POST[$tphead] != $tplabel) {
				$text = $_POST[$tphead];
				$class="1";
			}else{
				$text = $tplabel;
			}
			$order = "";
			$imgorder = "";
			if($_POST['order']!="desc" && $_POST['sort'] == $tphead)
			{
				$order = "desc";
				$imgorder = "down";
			}else{
				$order = "asc";
				$imgorder = "up";
			}
			array_push($headers,array('id'=>$tphead,'size'=>$this->sizes[$i],'text'=>$text,'style'=>$class,'order'=>$order,'imgorder'=>$imgorder,'display'=>$this->displays[$i]));
		}
		$this->smarty->assign('headers',$headers);
	}

	function generate_datas()
	{
		$key = $this->key;
		$datas = array();

		$sql_datas = $this->db->db_query($this->query);
		
		
		while($ligne = $this->db->db_fetch_object($sql_datas))
		{

		// rcuprer les droits au niveau de l'action Control
		
		if(is_object($this->actionControl))
			{
			if(method_exists($this->actionControl,'getFrozenFields'))
				{
				$frozenFields=$this->actionControl->getFrozenFields($ligne->$key);
				}
			}

			
			$tmp = array();
			for($i = 0 ; $i < $this->nb_headers ; $i++)
			{
				$tphead = $this->headers[$i];
				$id = $tphead.$ligne->$key;
				$value = $ligne->$tphead;

				$size = $this->sizes[$i];
				$type = $this->types[$i];
				
				$ajc_somme_special = 0 ; // Somme sur les liens voir
				
				if($type == "SPECIAL")
				{
					$array_values = $this->values[$i];
					if($array_values != "")
					{
						$exp = explode("=",$array_values);
						if(count($exp) > 1)
						{
							$arg1 = $exp[0];
							$arg2 = $exp[1];
						}else{
							$arg1 = $exp[0];
							$arg2 = $exp[0];
						}
					}else{
						$arg1 = $key;
						$arg2 = $key;
					}
					$value = str_replace("[where]",$arg1."='".$ligne->$arg2."'",$this->defauts[$i]);
					
				// recherche si la table est spcifie
				// Dans ce cas on calcule le total
				if($arg1 && $ligne->$arg1) 
					{
					$ajc_tableau = parse_url($this->defauts[$i]);
					$ajc_argument1 = explode( 'tblink=' , $ajc_tableau['query'] ) ;
					// au cas o il existe des arguments supplmentaires aprs
	
					if($ajc_argument1[1])
						{
						$ajc_argument2 = explode( '&' , $ajc_argument1[1] ) ;
						$ajc_table=$ajc_argument2[0] ;
						if( in_array($ajc_table,$this->tablesOfBase)  )
							{
							// ok la table existe on va calculer la somme
							
							if($arg1 != $arg2 && 1==0)
								{
								// Rcuprer la valeur du champs (code) servant de lien
								// Exemple : SELECT count(*) FROM RISQUE a1 , CLIENT a2 WHERE a1.Client_Id=a2.Client_Id AND a2.Code='LOGMET5900'
								$ajc_requete = "SELECT count(*) as total FROM ".$ajc_table." a1 , ".$this->table." a2 WHERE a1.$arg1=a2.$arg1 AND a2.$arg2='".$ligne->$arg2."'" ;
								}
							else
								{
								$ajc_requete = "SELECT COUNT(*) as total FROM ".$ajc_table." WHERE $arg1='".$ligne->$arg1.";' OR $arg1='".$ligne->$arg1."'" ;
								}
							
							if($_GET['debugajc']==1) {  echo $ajc_requete ;}

							$ajc_somme_request = mysql_query($ajc_requete) ;
							$ajc_somme_result = mysql_fetch_array($ajc_somme_request) ;
							$ajc_somme_special = $ajc_somme_result[total];

							}
						}
					}
				// fin calcul total
					
					
					
					
				}
				
				$alt_link='';
				if($type=='LINK')
				{
					$explodeLink=explode('|',$value);
					if(sizeof($explodeLink)==2)
					{
						$value=$explodeLink[1];
						$alt_link=$explodeLink[0];	
					}
				}
				
				
				$linked = "";
				if($type == "RECHERCHE" || $type == "LINKED" || $type == "COMPLETION")
				{
					$id_link = "LINKED_".$tphead;
					$vals = explode(";",$value);
					if(count($vals) > 1)
					{
						$tp_vals = explode(",",$this->values[$i]);
						$select = $tp_vals[0];
						$egal = $tp_vals[1];
						if($egal == "")
						{
							$egal = $tphead;
						}
						foreach($vals as $val)
						{
							$tp_query_vals = $this->db->db_query("SELECT $select AS Value FROM ".$this->defauts[$i]." WHERE $egal='$val'");
							while($tp_query_val = $this->db->db_fetch_object($tp_query_vals))
							{
								$linked .= $tp_query_val->Value." ";
							}
						}
					}else{
						$linked = $ligne->$id_link;
					}
				}

				if($type == "SUM")
				{
					$id_link = "SUM_".$tphead;
					$value = $ligne->$id_link;
				}

				$next = array();
				if($type == "ROLL")
				{
					if(!strrpos($value,";"))
					{
						$value = $this->defauts[$i];
					}
					$tmp_array = explode(";",$value);
					foreach ($tmp_array as $tmp_item)
					{
						$tmp_ar = explode(",",$tmp_item);
						$tmp_linked = explode(":",$tmp_ar[0]);
						$tmp_next = explode(":",$tmp_ar[1]);
						array_push($next,array('nom'=>$tmp_linked[1],'array_next'=>$tmp_next[1]));
					}
				}
				$value = htmlentities($value);
				if($this->read_perm[$i] == "0")
				{
					$type="NONE";
				}else{
					if($this->write_perm[$i] == "0")
					{
						$type="RO";
						if($type != "INPUT" && $type != "RECHERCHE")
						{
							$type="RO";
						}
					}
				}
				$col_wf_actif = "AWF_".$tphead;
				$col_wf_droit = "DWF_".$tphead;
				$wf_actif = "0";
				$wf_droit = "0";
				if($ligne->$col_wf_actif == "1")
				{
					$wf_actif = "1";
				}
				if($ligne->$col_wf_droit == "1")
				{
					$wf_droit = "1";
				}

				$frozenField=false;
				if(is_array($frozenFields))
					{
					if(in_array($tphead,$frozenFields) || $frozenFields[0]=='freezeAll')
						{
						$frozenField=true;

						if($type=="COMPLETION")
							{
							$value=$linked;
							}

						if($type != "RECHERCHE" && $type != "SPECIAL" )
							{
								$type="RO";
							}

						/*
						echo $type.' ' ;
						if($type=="SPECIAL")
							{
							$frozenField=false;
							}
						*/

						}
					}

				array_push($tmp,array('col'=>$tphead,'value'=>$value,'size'=>($size+3),'id'=>$id,'type'=>$type,'linked'=>$linked,'table'=>($this->defauts[$i]),'workflow_col'=>$this->workflows[$i],'next'=>$next,'wf_droit'=>$wf_droit,'wf_actif'=>$wf_actif,'display'=>$this->displays[$i],'keypressed'=>$this->keyPressCustom[$i],'alt_link'=>$alt_link,'mouseover'=>$this->mouseover[$i],'keypressed'=>$this->keyPressCustom[$i],'sommespecial'=>$ajc_somme_special,'frozenField'=>$frozenField ));
			}
			if(is_array($this->selectionCaddie))
				{
				$isInCaddie=(in_array($ligne->$key,$this->selectionCaddie))?1:0;
				}
			else
				{
				$isInCaddie=0;
				}
			
			array_push($datas,array('ligneid'=>$ligne->$key,'values'=>$tmp,'isInCaddie'=>$isInCaddie));
		}
		$this->smarty->assign('datas',$datas);
		unset($sql_datas);
	}

	function generate_totals()
	{
		$totals = array();
		$select_sql_query = "";
		for($i = 0 ; $i < $this->nb_headers ; $i++)
		{
			if($this->totaux[$i]=="1")
			{
				$head = $this->headers[$i];
				$select_sql_query .= "SUM($head) AS TOTAL_$head,";
			}
		}
		$select_sql_query .= "COUNT(".$this->key.") AS Nombre";
		$qu_tot = "SELECT $select_sql_query FROM (".$this->mini_query.") AS tempo";

		$resultats = $this->db->db_query($qu_tot);
		$resultat = $this->db->db_fetch_object($resultats);
		for($i = 0 ; $i < $this->nb_headers ; $i++)
		{
			if($this->totaux[$i]=="1")
			{
				$head = "TOTAL_".$this->headers[$i];
				$res = $resultat->$head;
				array_push($totals,array('value'=> $res ));
			}else{
				array_push($totals,array('value' => '' ) );
			}
		}
		$this->smarty->assign('col_totals',$totals);
		$this->smarty->assign('page_max',$resultat->Nombre);
		$this->max_elems = $resultat->Nombre;
		
		
		
	}

	function generate_tools()
	{
		$this->smarty->assign('role',$_SESSION["role_id"]);
	}

	function do_action($action)
	{
		switch($action)
		{
			case "EXP":
				include("export_include.php");
				export_cvs_table($this->no_limit_query);
				break;

			case "REM":

				if(is_object($this->actionControl)) {
					if(method_exists($this->actionControl,'canSearchReplace')) {
						if(!$this->actionControl->canSearchReplace($ligne->$key,$_POST['rr_colonne'])) {
						echo $this->actionControl->message."<br>" ;
						return (0) ;
						}
					}
				}


				//$rem_query = "UPDATE ".$this->table." SET ".$_POST['rr_colonne']."=REPLACE(".$_POST['rr_colonne'].",'".$_POST['rr_recherche']."','".$_POST['rr_par']."')  WHERE ".$_POST['rr_colonne']." like '%".$_POST['rr_recherche']."%' AND ".$this->key." IN (SELECT ".$this->key." FROM ((".$this->no_limit_query.") AS Temp ))";
				$sp_query=$this->no_limit_query;
				$que= $this->db->db_query($sp_query);
				$key = $this->key;
				$col = $_POST['rr_colonne'];

				// Rechercher le type de la colonne dfini dans la configuration des champs
				// Rechercher l'index de la colonne dans le tableau headers des colonnes
				$indexHeader = -1 ;
				foreach($this->headers as $key2 => $value2)
					{
					if($value2 == $col) 
						{
						$indexHeader=$key2 ;
						break ;
						}
					}

				// La colonne n'a pas t trouve on interromp l'action
				if($indexHeader==-1)
					{
					return(false) ;
					}

				// Si le type est gal  RECHERCHE ou COMPLETION on force la stricte galit pour le remplacement
				if( strtolower($this->types[$indexHeader])=='recherche' || strtolower($this->types[$indexHeader])=='completion')
					{
					echo "Action rechercher-remplacer, attribution automatique de strictement gal, type RECHERCHE ou COMPLETION" ;
					$_POST['rr_str']='on' ;
					}

				while($id = $this->db->db_fetch_object($que))
				{
				$do_update=1;
				$col = $_POST['rr_colonne'];

				// Vrification de la stricte galit si elle est impose
				if( isset($_POST['rr_str']) &&  ($id->$col != $_POST['rr_recherche']) && ($id->$col != $_POST['rr_recherche'].';') )
					{
					//echo '<br>ignore '.$id->$col ;
					$do_update=0;
					}
					
				if($do_update==1)
					{
					
					$val = $id->$col;
					if($_POST['rr_recherche'] == "" && $val == "")
						{
						$res = $_POST['rr_par'];
						}
					else{
						$res = str_replace($_POST['rr_recherche'],$_POST['rr_par'],$val);
						}

					$rem_query = "UPDATE ".$this->table." SET ".$_POST['rr_colonne']."='$res' ";
					if($val == "" && $_POST['rr_recherche'] == "")
						{
						$rem_query .= " WHERE (".$_POST['rr_colonne']." like '%".$_POST['rr_recherche']."%' OR  ".$_POST['rr_colonne']."  IS NULL ) AND ".$key."='".$id->$key."' ";
						}
					else{
						$rem_query .= " WHERE ".$_POST['rr_colonne']." like '%".$_POST['rr_recherche']."%' AND ".$key."='".$id->$key."'";
						}
					//echo $rem_query;
					$this->db->db_update($rem_query);
					}
				}
				break;

			case "MAJ":
				$this->update_table($this->table,$this->headers,$this->defauts,$this->key);
				break;

			case "ADD":
				$this->update_table($this->table,$this->headers,$this->defauts,$this->key);
				$this->add_row_table($this->table,$this->headers,$this->defauts,$this->key);
				break;

			case "ADD5":
				$this->update_table($this->table,$this->headers,$this->defauts,$this->key);
				$this->add_row_table($this->table,$this->headers,$this->defauts,$this->key);
				$this->add_row_table($this->table,$this->headers,$this->defauts,$this->key);
				$this->add_row_table($this->table,$this->headers,$this->defauts,$this->key);
				$this->add_row_table($this->table,$this->headers,$this->defauts,$this->key);
				$this->add_row_table($this->table,$this->headers,$this->defauts,$this->key);
				break;

			case "ADD10":
				$this->update_table($this->table,$this->headers,$this->defauts,$this->key);
				$this->add_row_table($this->table,$this->headers,$this->defauts,$this->key);
				$this->add_row_table($this->table,$this->headers,$this->defauts,$this->key);
				$this->add_row_table($this->table,$this->headers,$this->defauts,$this->key);
				$this->add_row_table($this->table,$this->headers,$this->defauts,$this->key);
				$this->add_row_table($this->table,$this->headers,$this->defauts,$this->key);
				$this->add_row_table($this->table,$this->headers,$this->defauts,$this->key);
				$this->add_row_table($this->table,$this->headers,$this->defauts,$this->key);
				$this->add_row_table($this->table,$this->headers,$this->defauts,$this->key);
				$this->add_row_table($this->table,$this->headers,$this->defauts,$this->key);
				$this->add_row_table($this->table,$this->headers,$this->defauts,$this->key);
				break;

			case "WRK":
				$this->update_table($this->table,$this->headers,$this->defauts,$this->key);
				$this->workflow_validate_table($this->table,$_POST["wf_key"],$_POST["wf_col"]);
				break;

			case "UWK":
				$this->update_table($this->table,$this->headers,$this->defauts,$this->key);
				$this->workflow_unvalidate_table($this->table,$_POST["wf_key"],$_POST["wf_col"]);
				break;

			case "DEL":
				$this->delete_row_table($this->table,$this->headers,$this->key);
				break;

			case "DUP":
				$this->update_table($this->table,$this->headers,$this->defauts,$this->key);
				$this->duplicate_row_table($this->table,$this->headers,$this->key);
				break;

			case "FIL":
				$this->filtre_table($this->table,$this->headers,$this->key,$_POST["filtre_id"]);
				break;

			case "LOC":
				include('locate.php');
				break;

			case "WAY":
				include('trajet.php');
				break;

			case "SFI":
				$this->create_filtre_table($this->table,$this->headers,$this->key,$_POST["filtre_id"]);
				break;

			case "SEQ":
				echo "Sequence";
				$this->sequence_table($_POST['sq_key'],$_POST['sq_col'],$_POST['sq_nex']);
				break;

			case "ADD_CADDIE":
				//echo "Ajouter au caddie" ;
				//print_r($_SESSION);
				$this->add_to_caddie();
				break ;

			case "VIDE_CADDIE":
				$this->del_caddie();
				break ;

			case "SUP_CADDIE":
				$this->del_elt_caddie() ;
				break ;

		}
	}

	function add_row_table($table,$headers,$defauts,$key)
	{
		if(is_object($this->actionControl)) {
			if(method_exists($this->actionControl,'canInsert')) {
				if(!$this->actionControl->canInsert()) {
				echo $this->actionControl->message."<br>" ;
				return(0);
				}
			}
		}

		$insert = "";
		$values = "";
		$headers = array();
		$heads = $this->db->db_query("DESCRIBE $table");
		while($head = $this->db->db_fetch_object($heads))
		{
			array_push($headers,$head->Field);
		}
		$nb_headers = count($headers);
		for($i = 0 ; $i < $nb_headers ; $i++)
		{
			$insert .= "`".$headers[$i]."`,";
			$temp = $headers[$i];
			$types = $this->db->db_query("SELECT Label,Type,Defaut,Value FROM ".DB_NAME.".CONFIG WHERE Module_Id = '".$this->module_id."' AND Colonne='$temp'");
			$resultat = $this->db->db_fetch_object($types);
			$type = $resultat->Type;
			$defaut = $resultat->Defaut;
			$value = $resultat->Value;
			$label = $resultat->Label;
			if ($_POST[$temp] !="" && $_POST[$temp] != $label) {
				if($type == "RECHERCHE" || $type=="LINKED")
				{
					$tp_query = "SELECT $temp AS Value FROM ".$defaut." WHERE ".$value."='".$_POST[$temp]."' LIMIT 1";
					$res_tp_query = $this->db->db_query($tp_query);
					$re_tp_query=$this->db->db_fetch_object($res_tp_query);
					$values .= "'".$re_tp_query->Value."',";
				}else{
					$values .= "'".$_POST[$temp]."',";
				}
			}else{
				$def = $defaut;
				if($_SESSION[$def] != "")
				{
					$values .= "'".$_SESSION[$def]."',";
				}else{
					$values .= "'".$defaut."',";
				}
			}
		}
		$insert = substr($insert,0,strlen($insert)-1);
		$values = substr($values,0,strlen($values)-1);
		$sql_query = "INSERT INTO $table ($insert) VALUES ($values)";



		if($this->db->db_insert($sql_query))
		{
		$newId=mysql_insert_id();
		if(is_object($this->actionControl))
			{
			if(method_exists($this->actionControl,'afterInsert'))
				{
				$this->actionControl->afterInsert($newId);
				}
			}


			//$this->throw_infos("[ADD] Ajout d'une ligne OK");
		}else{
			//$this->throw_errors("[ADD] Erreur lors de l'ajout d'une ligne");
		}
	}

	function update_table($table,$headers,$defauts,$key)
	{
		$values = $this->db->db_query($this->query);
		while($ligne = $this->db->db_fetch_object($values))
		{
			$sem = "SEM".$ligne->$key;
			if($_POST[$sem] == "ON")
			{
				for($i = 0 ; $i < $this->nb_headers ; $i++)
				{
					$value = $headers[$i];
					$t = $value."".$ligne->$key;
					$val = $_POST[$t];
					$prev = $this->db->db_query("SELECT $value FROM $table WHERE $key='".$ligne->$key."'");
					$pre = $this->db->db_fetch_object($prev);
					if($pre->$value != $val)
					{
						$arch = "INSERT INTO ".DB_NAME.".ARCHIVAGE VALUES('','$table','".$ligne->$key."','$value','".$pre->$value."','".date('ymdHis')."','".$_SESSION['login']."','')";
						$upd = "UPDATE $table SET $value = '$val' WHERE $key='".$ligne->$key."'";
						$this->db->db_insert($arch);
						$this->db->db_update($upd);
					}
				}
			}
		}
	}

	function duplicate_row_table($table,$headers,$key)
	{
		$values = $this->db->db_query($this->query);
		while($ligne = $this->db->db_fetch_object($values))
		{
			$check = "CK".$ligne->$key;
			if("$_POST[$check]" == "on")
			{
			$dupliquer=1;
			if(is_object($this->actionControl)) {
				if(method_exists($this->actionControl,'canDuplicate')) {
					if(!$this->actionControl->canDuplicate($ligne->$key)) {
					echo $this->actionControl->message."<br>" ;
					$dupliquer=0 ;
					}
				}
			}

			if($dupliquer==1)
				{
				$insert = "";
				$fields = $this->db->db_query("DESCRIBE $table");
				while($field = $this->db->db_fetch_object($fields))
					{
						$value = $field->Field;
						if($value != $key)
						{
							$insert .= "'".addslashes($ligne->$value)."'";
							$insert .= ",";
						}else{
							$insert .= "''";
							$insert .= ",";
						}
					}

				$insert = substr($insert,0,strlen($insert)-1);
				$sql_query = "INSERT INTO $table VALUES($insert)";
				$this->db->db_insert($sql_query);
				$newId=mysql_insert_id();
				$this->save_actions($table,$ligne->$key,"DUP",$sql_query);
				if(is_object($this->actionControl))
					{
					if(method_exists($this->actionControl,'afterDuplicate'))
						{
						$this->actionControl->afterDuplicate($newId)."<br>";
						}
					}
				}
			}
		}
	}

	function delete_row_table($table,$headers,$key)
	{
		$values = $this->db->db_query($this->query);
		while($ligne = $this->db->db_fetch_object($values))
		{
			$check = "CK".$ligne->$key;
			if("$_POST[$check]" == "on")
			{
				$supprimer=1;
				if(is_object($this->actionControl))
					{
					if(method_exists($this->actionControl,'canSuppress'))
						{
						if(!$this->actionControl->canSuppress($ligne->$key))
							{
							$supprimer=0;
							}
						}
					}

			if($supprimer==1)
					{
					$this->save_actions($table,$ligne->$key,"DEL",implode(",",$this->db->db_fetch_array($this->db->db_query("SELECT * FROM $table WHERE $key= '".$ligne->$key."'"))));
					$this->db->db_delete("DELETE FROM $table WHERE $key= '".$ligne->$key."'");
					}
				else
					{
					echo $this->actionControl->message."<br>" ;
					}

			}
		}
	}

	function workflow_validate_table($table,$key,$colonne)
	{
		$this->db->db_insert("INSERT INTO WORKFLOW VALUES('','$table','$key','$colonne','true','')");
	}

	function workflow_unvalidate_table($table,$key,$colonne)
	{
		$this->db->db_insert("DELETE FROM WORKFLOW WHERE Objet_Id='$key' AND Colonne_Id='$colonne' AND Valider='true'");
	}

	function sequence_table($key,$colonne,$step_suivant)
	{
		$steps = $this->db->db_query("SELECT Module_Id,Colonne_Id,Action,Step,Nexts FROM CYCLE WHERE Module_Id='".$this->table."' AND Colonne_Id='$colonne' AND Step='$step_suivant'");
		$step = $this->db->db_fetch_object($steps);
		if(file_exists("apps/".$_SESSION['app']."/scripts/functions_".$this->table.".php"))
		{
			include("apps/".$_SESSION['app']."/scripts/functions_".$this->table.".php");
			$funtion = "step_".$step_suivant."($key,$colonne)";
			$$function;
		}
		$nexts = explode(",",$step->Nexts);
		$res = "";
		foreach($nexts as $next)
		{
			$steps = $this->db->db_query("SELECT Nom FROM CYCLE WHERE Module_Id='".$this->table."' AND Colonne_Id='$colonne' AND Step='$next'");
			$step = $this->db->db_fetch_object($steps);
			$res.="LINK:".$step->Nom.",NEXT:$next;";
		}
		$this->db->db_query("UPDATE ".$this->table." SET $colonne ='$res' WHERE ".$this->key."='$key'");
	}

	function save_actions($table_id,$object_id,$action,$description)
	{
		//echo "INSERT  INTO  ".DB_NAME.".ACTION (  `Action_Id` ,  `Module_Id` ,  `Object_Id` ,  `User_Id` ,  `Description` ,  `Type_action` ,  `Date`  ) VALUES ( '',  '$table_id',  '$object_id',  '".$_SESSION['user_id']."',  '$description',  '$action',  '".date('ymdHis')."')" ;
		$description = addslashes($description);
		$this->db->db_insert("INSERT  INTO  ".DB_NAME.".ACTION (  `Action_Id` ,  `Module_Id` ,  `Object_Id` ,  `User_Id` ,  `Description` ,  `Type_action` ,  `Date`  ) VALUES ( '',  '$table_id',  '$object_id',  '".$_SESSION['user_id']."',  '$description',  '$action',  '".date('ymdHis')."')");
	}

	function throw_errors($string_errors)
	{
		$this->smarty->assign('error',$string_errors);
		$this->smarty->display('miniclick/miniclick_errors.tpl');
	}

	function throw_infos($string_infos)
	{
		$this->smarty->assign('info',$string_infos);
		$this->smarty->display('miniclick/miniclick_infos.tpl');
	}


	function debut_calcultemps() {
		$trouver_temps = explode(' ',microtime() );
		$temps_debut = $trouver_temps[1].substr($trouver_temps[0], 1);
		return $temps_debut;
	}

	function ecrire_temps($temps_debut,$precision) {
		$partie_temps = explode(' ',microtime() );
		$fin_temps = $partie_temps[1].substr($partie_temps[0],1);
		$chrono = number_format($fin_temps - $temps_debut, 4);
		if($precision > strlen($chrono)) {
			$chrono = substr($chrono, 0, strlen($chrono)); //on donne la precision maximale
		} else {
			$chrono = substr($chrono, 0, $precision);
		}
		return $chrono;
	}


	function getTableOfBase() {
		
		$listOfTable = array();
		$r = mysql_query("SHOW TABLES") ;
		while($v=mysql_fetch_array($r))
		{
			$listOfTable[]=$v[0];
		}
		
		return $listOfTable ;
	}

	
	function getOrderFromVue() {

	$order='';

	$vueTri = trim(ereg_replace('( ){2,}',' ',$this->vue_tri)) ;
	$listOfOrder = explode(',',$vueTri) ;

	if(is_array($listOfOrder))
		{
		foreach($listOfOrder as $key => $value)
			{
			$value=trim($value);
			list($field,$sens)=explode(' ',$value) ;
			$field=trim($field);
			$sens=trim($sens) ;
			if(in_array($field,$this->headers))
				{
				if( strtolower($sens)=='desc' )
					{
					$order .= " `$field` DESC ," ;
					}
				else
					{
					$order .= " `$field` ," ;
					}
				}
			}
		}
	
	if($order != '')
		{
		// enlever le ', ' en fin de chane
		$order = ' ORDER BY '.substr($order,0,-2) ;
		}

	return($order);

	}


	function add_to_caddie() {
		// Ajoute les lments slectionns au caddie

		$key = $this->key ;
		$values = $this->db->db_query($this->query);

		while($ligne = $this->db->db_fetch_object($values))
		{
		if( !in_array($ligne->$key,$this->selectionCaddie) )
			{
			$check = "CK".$ligne->$key;
			if($_POST[$check] == "on")
				{
				$this->save_actions($table,$ligne->$key,"ADD_CADDIE",implode(",",$this->db->db_fetch_array($this->db->db_query("SELECT * FROM ".$this->table." WHERE $key= '".$ligne->$key."'"))));
				$this->db->db_query("INSERT INTO ".DB_NAME.".SELECT_MN SET date=NOW(), user_id=".$_SESSION['user_id'].', module_id='.$this->module_id.', enr_id='.$ligne->$key  );
				}
			}
		}

	$this->getElementInCaddie();
	}

	function del_caddie() {
		// Vide les lments prsents dans le caddie
		$this->db->db_query("DELETE FROM ".DB_NAME.".SELECT_MN WHERE user_id='".$_SESSION['user_id']."' AND module_id='".$this->module_id."'");
		$this->selectionCaddie=array();
	}


	function del_elt_caddie() {
	// Efface un ou des lments du caddie

		$key = $this->key ;
		$values = $this->db->db_query($this->query);

		while($ligne = $this->db->db_fetch_object($values))
		{		
		if( in_array($ligne->$key,$this->selectionCaddie) )
			{
			$check = "CK".$ligne->$key;
			if($_POST[$check] == "on")
				{
				$this->save_actions($table,$ligne->$key,"SUP_CADDIE",implode(",",$this->db->db_fetch_array($this->db->db_query("SELECT * FROM ".$this->table." WHERE $key= '".$ligne->$key."'"))));
				$this->db->db_query("DELETE FROM ".DB_NAME.".SELECT_MN WHERE user_id=".$_SESSION['user_id'].' AND  module_id='.$this->module_id.' AND enr_id='.$ligne->$key  );
				}
			}
		}

	$this->getElementInCaddie();



	}

	function affecteCaddie() 
		{
		// Modifier la condition where pour afficher uniquement la slection du caddie
		
		$r=$this->db->db_query("SELECT * FROM ".DB_NAME.".SELECT_MN WHERE user_id='".$_SESSION['user_id']."' AND module_id='".$this->module_id."'");
		if(mysql_num_rows($r))
			{
			$condition = $this->key. " IN ("."SELECT enr_id FROM ".DB_NAME.".SELECT_MN WHERE user_id='".$_SESSION['user_id']."' AND module_id='".$this->module_id."'".")" ;
			if($this->whereImpose)
				{
				$this->whereImpose .= 'AND '.$condition.' ' ;
				}
			else
				{
				$this->whereImpose = $condition.' ' ;
				}
			}
		else
			{
			echo '<br><br>&nbsp;&nbsp;&nbsp;Aucun lment dans le Caddie<br><br>' ;
			exit();
			}
		}

	function getElementInCaddie()
		{
		$tab=array();
		$r=$this->db->db_query("SELECT enr_id FROM ".DB_NAME.".SELECT_MN WHERE user_id='".$_SESSION['user_id']."' AND module_id='".$this->module_id."'");
		while($v=mysql_fetch_array($r))
			{
			$tab[]=$v['enr_id'];
			}
		$this->selectionCaddie=$tab;
		}
	

}
?>