# OGG
# http://www.xiph.org/ogg/

PKG            := ogg
$(PKG)_VERSION := 1.1.3
$(PKG)_SUBDIR  := libogg-$($(PKG)_VERSION)
$(PKG)_FILE    := libogg-$($(PKG)_VERSION).tar.gz
$(PKG)_URL     := http://downloads.xiph.org/releases/ogg/$($(PKG)_FILE)
$(PKG)_DEPS    := gcc

define $(PKG)_UPDATE
    wget -q -O- 'http://www.xiph.org/downloads/' | \
    $(SED) -n 's,.*libogg-\([0-9][^>]*\)\.tar.*,\1,p' | \
    head -1
endef

define $(PKG)_BUILD
    # wine confuses the cross-compiling detection, so set it explicitly
    $(SED) 's,cross_compiling=no,cross_compiling=yes,' -i '$(1)/configure'
    cd '$(1)' && ./configure \
        --host='$(TARGET)' \
        --disable-shared \
        --prefix='$(PREFIX)/$(TARGET)'
    $(MAKE) -C '$(1)' -j '$(JOBS)' install bin_PROGRAMS= sbin_PROGRAMS= noinst_PROGRAMS=
endef
