/*
  upad - A program for debugging, and uploading code to embedded devices.
  Copyright (C) 2016, 2019 John Darrington

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __UPLOADER_H
#define __UPLOADER_H

#include <stdbool.h>
#include <stdint.h>
#include <stddef.h>

#include "upad.h"

struct upload_format
{
  bool (*get_data_fragment) (struct upload_format *uf, tgt_addr *address,
                             uint8_t *buffer, size_t bufsize, size_t *n_data);
  void (*destroy) (struct upload_format *uf);
};

#endif

/* Local Variables:  */
/* mode: c           */
/* c-style: "gnu"    */
/* End:              */
