#!/bin/sh
# upad - A program for debugging, and uploading code to embedded devices.
# Copyright (C) 2016, 2019 John Darrington

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

#purpose: This test makes sure that gdb can connect.  Not much more!

tempdir=$(mktemp -d)

pass ()
{
    kill $serverpid
    kill -9 $serverpid
    rm -rf $tempdir;
    exit 0
}

fail ()
{
    kill -9 $serverpid
    rm -rf $tempdir;
    exit 1
}

no_result ()
{
    kill -9 $serverpid
    rm -rf $tempdir;
    exit 2
}

port=3901

$BINARY --gdb-server  --gdb-port=$port --no-interactive &
serverpid=$!

# Run GDB with a new HOME in case a .gdbinit file interferes with us
HOME=$tempdir gdb -batch --ex="set remotelogfile $tempdir/log" \
    --ex="target remote localhost:$port" \
    --ex="quit"  > /dev/null 2> /dev/null
if test $? -ne 0; then fail; fi


grep -A 1  -F  -e '$?' $tempdir/log > $tempdir/xx
if test $? -ne 0; then fail; fi


# Make sure that we entered remote mode
diff $tempdir/xx - << 'EOF'
w $?#3f
r $S00#b3
EOF
if test $? -ne 0; then fail; fi

pass
