#!/bin/sh
# upad - A program for debugging, and uploading code to embedded devices.
# Copyright (C) 2016, 2019 John Darrington

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

#purpose: This test makes sure that the bounce code algorithm works ok

tempdir=$(mktemp -d)

pass ()
{
    rm -rf $tempdir;
    exit 0
}

fail ()
{
    rm -rf $tempdir;
    exit 1
}

no_result ()
{
    rm -rf $tempdir;
    exit 2
}

address=FF0000

cat <<EOF  > $tempdir/testfile
Mary had a little lamb,
Its fleece as white as snow.
And everywhere that Mary went,
That lamb was sure to go.
EOF
if test $? -ne 0; then no_result; fi

# Generate a few bytes of rubbish
dd if=/dev/urandom of=$tempdir/rubbish bs=1 count=96 2> /dev/null
if test $? -ne 0; then no_result; fi

# Make sure that using rubbish as the bounce code, fails with an error
$BINARY --bounce=$tempdir/rubbish --binary=0x$address $tempdir/testfile 2> /dev/null > /dev/null
if test $? -eq 0; then fail; fi

# Now use the proper bounce code
$BINARY --bounce=$top_srcdir/target/s12z/bounce.bin --binary=0x$address $tempdir/testfile
if test $? -ne 0; then no_result; fi

# and check that it programmed correctly
cat <<EOF  > $tempdir/cmds
reset-bdm
sync
read-mem 0x$address 110
EOF
if test $? -ne 0; then no_result; fi

$BINARY --bounce=$top_srcdir/target/s12z/bounce.bin -T $tempdir/cmds > $tempdir/result
if test $? -ne 0; then no_result; fi

diff $tempdir/result - <<EOF
00FF0000:  Mary had  a littl   4D 61 72 79 20 68 61 64   20 61 20 6C 69 74 74 6C
00FF0010:  e lamb,. Its flee   65 20 6C 61 6D 62 2C 0A   49 74 73 20 66 6C 65 65
00FF0020:  ce as wh ite as s   63 65 20 61 73 20 77 68   69 74 65 20 61 73 20 73
00FF0030:  now..And  everywh   6E 6F 77 2E 0A 41 6E 64   20 65 76 65 72 79 77 68
00FF0040:  ere that  Mary we   65 72 65 20 74 68 61 74   20 4D 61 72 79 20 77 65
00FF0050:  nt,.That  lamb wa   6E 74 2C 0A 54 68 61 74   20 6C 61 6D 62 20 77 61
00FF0060:  s sure t o go..     73 20 73 75 72 65 20 74   6F 20 67 6F 2E 0A      
EOF
if test $? -ne 0; then fail; fi

pass
