#!/bin/sh
# upad - A program for debugging, and uploading code to embedded devices.
# Copyright (C) 2016, 2019 John Darrington

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

#purpose: This test makes sure that the remote md5sum check works properly.

tempdir=$(mktemp -d)

pass ()
{
    rm -rf $tempdir;
    exit 0
}

fail ()
{
    rm -rf $tempdir;
    exit 1
}

no_result ()
{
    rm -rf $tempdir;
    exit 2
}

cat <<EOF  > $tempdir/testfile
There once was a many who said God,
Would find it exceedingly odd,
If in the quad, that tree,
Should continue to be,
When no-one's around in the Quad.
EOF
if test $? -ne 0; then no_result; fi

bytes=`wc -c $tempdir/testfile | awk '{print $1}'`


cat <<EOF  > $tempdir/cmds
reset-bdm
sync
upload-binary $tempdir/testfile 0x2000
md5-check 0x2000 $bytes
EOF
if test $? -ne 0; then no_result; fi

$BINARY --no-bounce -T $tempdir/cmds | tail -1 > $tempdir/md5-remote
if test $? -ne 0; then no_result; fi

md5sum $tempdir/testfile  | awk '{print $1}' > $tempdir/md5-local
if test $? -ne 0; then no_result; fi

diff $tempdir/md5-remote  $tempdir/md5-local
if test $? -ne 0; then fail; fi


pass
