#!/bin/sh
# upad - A program for debugging, and uploading code to embedded devices.
# Copyright (C) 2016, 2019 John Darrington

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

#purpose: This test makes sure that uploading binary files works ok.

tempdir=$(mktemp -d)

pass ()
{
    rm -rf $tempdir;
    exit 0
}

fail ()
{
    rm -rf $tempdir;
    exit 1
}

no_result ()
{
    rm -rf $tempdir;
    exit 2
}

cat <<EOF  > $tempdir/testfile
Mary had a little lamb,
Its fleece as white as snow.
And everywhere that Mary went,
That lamb was sure to go.
EOF
if test $? -ne 0; then no_result; fi

cat <<EOF  > $tempdir/cmds
reset-bdm
sync
upload-binary $tempdir/testfile 0x1000
read-mem 0x1000 110
EOF
if test $? -ne 0; then no_result; fi

$BINARY --no-bounce -T $tempdir/cmds | grep -v "BDC" > $tempdir/result
if test $? -ne 0; then no_result; fi

diff $tempdir/result - <<EOF
00001000:  Mary had  a littl   4D 61 72 79 20 68 61 64   20 61 20 6C 69 74 74 6C
00001010:  e lamb,. Its flee   65 20 6C 61 6D 62 2C 0A   49 74 73 20 66 6C 65 65
00001020:  ce as wh ite as s   63 65 20 61 73 20 77 68   69 74 65 20 61 73 20 73
00001030:  now..And  everywh   6E 6F 77 2E 0A 41 6E 64   20 65 76 65 72 79 77 68
00001040:  ere that  Mary we   65 72 65 20 74 68 61 74   20 4D 61 72 79 20 77 65
00001050:  nt,.That  lamb wa   6E 74 2C 0A 54 68 61 74   20 6C 61 6D 62 20 77 61
00001060:  s sure t o go..     73 20 73 75 72 65 20 74   6F 20 67 6F 2E 0A      
EOF
if test $? -ne 0; then fail; fi

pass
