#!/bin/bash
# upad - A program for debugging, and uploading code to embedded devices.
# Copyright (C) 2016, 2019 John Darrington

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


# Generate a single S-Record

type=2
while test $# -gt 0; do
    case $1 in
	-t)
	    type=$2;
	    shift;
	    ;;
	-a)
	    address=$2;
	    shift;
	    ;;
	-d)
	    data=$2;
	    shift;
	    ;;
	*)
	    ;;
    esac
    shift;
done

# Length of the data
len=$[${#data} / 2]


case $type in
    1)
	alen=2;
	;;
    2)
	alen=3;
	;;
    3)
	alen=4;
	;;
    *)
	printf "Invalid type\n";
	exit 1;
	;;
esac

# length of the address
len=$[$len + $alen];

# Plus the checksum
len=$[$len + 1];


checksum=$[16#$len]

alen=$[$alen * 2]
while test $alen -gt 0; do
    alen=$[$alen - 2]
    checksum=$[checksum + $[16#${address:$alen:2}]]
done;

dlen=${#data}
while test $dlen -gt 0; do
    dlen=$[$dlen - 2]
    checksum=$[checksum + $[16#${data:$dlen:2}]]
done;


printf "S2"
printf "%02X" $len
printf "$address"
printf "$data"

# Take the one's complement:
checksum=$[checksum + 1]
checksum=$[checksum * -1]
hex=$(printf "%02X" $checksum)
len=${#hex}
printf ${hex:$[$len - 2]:2}

exit 0
