/*
  Copyright (C) 2016, 2019 John Darrington

  Copying and distribution of this file, with or without modification,
  are permitted in any medium without royalty provided the copyright
  notice and this notice are preserved.  This file is offered as-is,
  without any warranty.
*/
#include <stdint.h>


typedef struct
{
    __IOM uint8_t   DBGC1;                    /*!< 0x0100 */
    __IOM uint8_t   DBGC2;                    /*!< 0x0101 */
    __IM  uint8_t   RESERVED0[5];             /*!< 0x0102 */
    __IOM uint8_t   DBGSCR1;                  /*!< 0x0107 */
    __IOM uint8_t   DBGSCR2;                  /*!< 0x0108 */
    __IOM uint8_t   DBGSCR3;                  /*!< 0x0109 */
    __IM  uint8_t   DBGEFR;                   /*!< 0x010A */
    __IM  uint8_t   DBGGSR;                   /*!< 0x010B */
    __IM  uint8_t   RESERVED1[4];             /*!< 0x010C */
    __IOM uint8_t   DBGACTL;                  /*!< 0x0110 */
    __IM  uint8_t   RESERVED2[3];             /*!< 0x0111 */
    __IOM uint32_t  DBGAA;                    /*!< 0x0114 */
    __IOM uint32_t  DBGAD;                    /*!< 0x0118 */
    __IOM uint32_t  DBGADM;                   /*!< 0x011C */
    __IOM uint8_t   DBGBCTL;                  /*!< 0x0120 */
    __IM  uint8_t   RESERVED3[3];             /*!< 0x0121 */
    __IOM uint32_t  DBGBA;                    /*!< 0x0124 */
    __IM  uint8_t   RESERVED4[24];            /*!< 0x0128 */
    __IOM uint8_t   DBGDCTL;                  /*!< 0x0140 */
    __IM  uint8_t   RESERVED5[3];             /*!< 0x0141 */
    __IOM uint32_t  DBGDA;                    /*!< 0x0144 */
    __IM  uint8_t   RESERVED6[7];             /*!< 0x0148 */
} DBG_TypeDef;

#define DBG_BASE (0x0100U)
#define DBG ((DBG_TypeDef *) DBG_BASE)
