#!/bin/sh

# Copyright (C) 2016, 2019 John Darrington

# Copying and distribution of this file, with or without modification,
# are permitted in any medium without royalty provided the copyright
# notice and this notice are preserved.  This file is offered as-is,
# without any warranty.

# A script to check a CMSIS file for completness and consistency.

prefix=`sed -n -e 's/^#define  *\([A-Z]*\)_BASE .*/\1/p' $1`

addresses=`gawk '/\!</{print $5}' $1`

printf "#include \"$1\"\n"
printf "#include <assert.h>\n"
printf "#include <stddef.h>\n"
printf "int main () {"
for a in $addresses; do
    reg=`gawk '/!< '$a'/{print $3}' $1 | sed -e 's/;//' -e 's/\[.*\]//' `
    printf "assert ($a == offsetof (${prefix}_TypeDef, $reg) + ${prefix}_BASE);\n"
done
printf "return 0;}";
