/*
    upad - A program for debugging, and uploading code to embedded devices.
    Copyright (C) 2016, 2019 John Darrington

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/
#include <config.h>
#include "reset.h"

#include "upad-cfg.h"
#include "periph/gpio.h"
#include "xtimer.h"
#include "bdc.h"

void
reset (void)
{
  xtimer_ticks32_t last_wakeup = xtimer_now ();
  gpio_init (RESET_PIN, GPIO_OD);
  gpio_clear (RESET_PIN);
  xtimer_periodic_wakeup (&last_wakeup, 26000);
  gpio_set (RESET_PIN);
}

/* Enter background debug mode */
void
background_debug (void)
{
  xtimer_ticks32_t last_wakeup = xtimer_now ();
  bkgd_talk ();
  gpio_clear (BKGD_PIN);

  gpio_init (RESET_PIN, GPIO_OD);
  gpio_set (RESET_PIN);

  xtimer_periodic_wakeup (&last_wakeup, 4000);

  /* Toggle the reset pin while MODC/BKGD is low */
  gpio_clear (RESET_PIN);
  xtimer_periodic_wakeup (&last_wakeup, 26000);
  gpio_set (RESET_PIN);

  /* Keep MODC/BKGD low for a while */
  xtimer_periodic_wakeup (&last_wakeup, 104000);
  gpio_set (BKGD_PIN);
  xtimer_periodic_wakeup (&last_wakeup, 14000);

  /* Revert both pins to Hi_Z */
  gpio_init (RESET_PIN, GPIO_IN);
  bkgd_listen ();
}



/* Local Variables:  */
/* mode: c           */
/* c-style: "gnu"    */
/* End:              */
