/*
  upad - A program for debugging, and uploading code to embedded devices.
  Copyright (C) 2016 John Darrington

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef USER_INTERFACE_H
#define USER_INTERFACE_H

int run_interactive (int fpr);

enum ARG_TYPE
{
    ARG_ADDRESS,
    ARG_QUANTITY,
    ARG_FILENAME,
    ARG_DATUM
};

struct xcmd
{
  char *name;
  int (*call) (int fpr, int argc, char **argv);
  int n_args;
  const enum ARG_TYPE *args;
};

#define N_COMMANDS 21

extern const struct xcmd cmds[];


#endif
