/*
    upad - A program for debugging, and uploading code to embedded devices.
    Copyright (C) 2016 John Darrington

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __TRANSACTION_H__
#define __TRANSACTION_H__

#include <string.h>
#include <stdint.h>
#include <stdio.h>
#include <stdbool.h>

struct bounce_code_usage
{
  uint32_t address;
  uint32_t size;
  uint32_t size_register;
  uint32_t source_register;
  uint32_t dest_register;
  uint32_t pc_register;
  uint32_t err_register;
};

struct register_spec
{
    int reg;
    uint32_t value;
};

int write_fragment (int des, uint32_t addr, uint8_t *buffer, size_t n_bytes, const struct bounce_code_usage *bcu, bool first);

const struct memsector * get_memory_class (uint32_t address);

int execute_echo (int des, int size, FILE *fpin, FILE *fpout);
int execute_write_memory (int des, uint32_t addr, size_t n_bytes, uint8_t *tx_buf, const struct memsector *ms);
int execute_write_bdccsr (int des, uint16_t csr);
uint16_t execute_read_bdccsr (int des);
uint32_t execute_read_register (int des, int reg);
int execute_step (int des);
int execute_background (int des);
int execute_poll (int des);
int execute_go (int des);
int execute_reset (int des);
int execute_bulk_erase (int des);
int execute_reset_bdm (int des);
int execute_sync (int des);
int execute_erase_sector (int des, uint32_t address);
int remote_md5_check (int des, uint32_t address, uint32_t quantity, uint8_t *result);
int execute_read_all_regs (int des, uint32_t **reg_values, size_t *n_regs);

const uint8_t * execute_read_memory (int des, uint32_t address, int quantity);

int execute_write_regs (int des, int n_regs, const struct register_spec *rs);

int post_final (int des, const struct bounce_code_usage *bcu, uint32_t end);


#endif
