#!/bin/sh
# upad - A program for debugging, and uploading code to embedded devices.
# Copyright (C) 2016 John Darrington

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

tempdir=$(mktemp -d)

pass ()
{
    rm -rf $tempdir;
    exit 0
}

fail ()
{
    rm -rf $tempdir;
    exit 1
}

no_result ()
{
    rm -rf $tempdir;
    exit 2
}

cat >> $tempdir/stuff.s <<EOF
    .text
    .ascii "Now is the winter of our discontent."
    .org 0x100
    .ascii "Discontent is the now of our summer."
EOF
if test $? -ne 0; then no_result; fi

s12z-as $tempdir/stuff.s -o $tempdir/stuff.o
if test $? -ne 0; then no_result; fi

s12z-ld $tempdir/stuff.o -o $tempdir/stuff.elf
if test $? -ne 0; then no_result; fi

$BINARY --no-bounce $tempdir/stuff.elf
if test $? -ne 0; then fail; fi

cat <<EOF  > $tempdir/cmds
reset-bdm
sync
read-mem 0xFE0000 0x24
read-mem 0xFE0100 0x30
EOF
if test $? -ne 0; then no_result; fi

$BINARY --no-bounce -T $tempdir/cmds > $tempdir/result
if test $? -ne 0; then no_result; fi

diff -w $tempdir/result - <<EOF
00FE0000:  Now is t he winte   4E 6F 77 20 69 73 20 74   68 65 20 77 69 6E 74 65
00FE0010:  r of our  discont   72 20 6F 66 20 6F 75 72   20 64 69 73 63 6F 6E 74
00FE0020:  ent.                65 6E 74 2E
00FE0100:  Disconte nt is th   44 69 73 63 6F 6E 74 65   6E 74 20 69 73 20 74 68
00FE0110:  e now of  our sum   65 20 6E 6F 77 20 6F 66   20 6F 75 72 20 73 75 6D
00FE0120:  mer..... ........   6D 65 72 2E FF FF FF FF   FF FF FF FF FF FF FF FF
EOF
if test $? -ne 0; then fail; fi

pass
