#!/bin/sh
# upad - A program for debugging, and uploading code to embedded devices.
# Copyright (C) 2016 John Darrington

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# This test makes sure that the entire RAM can be written without error
# from a binary file
tempdir=$(mktemp -d)

pass ()
{
    rm -rf $tempdir;
    exit 0
}

fail ()
{
    rm -rf $tempdir;
    exit 1
}

no_result ()
{
    rm -rf $tempdir;
    exit 2
}

head --bytes=8192 COPYING > $tempdir/goo
if test $? -ne 0; then no_result; fi

cat <<EOF  > $tempdir/cmds
reset-bdm
sync
upload-binary $tempdir/goo 0x1000
md5-check 0x1000 8192
EOF
if test $? -ne 0; then no_result; fi

$BINARY --no-bounce -T $tempdir/cmds | tail -1 > $tempdir/md5-remote
if test $? -ne 0; then no_result; fi

md5sum $tempdir/goo  | awk '{print $1}' > $tempdir/md5-local
if test $? -ne 0; then no_result; fi

diff $tempdir/md5-remote  $tempdir/md5-local
if test $? -ne 0; then fail; fi


pass
