#!/bin/sh
# upad - A program for debugging, and uploading code to embedded devices.
# Copyright (C) 2016 John Darrington

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# Tests that CPU registers can be read and written

tempdir=$(mktemp -d)

pass ()
{
    rm -rf $tempdir;
    exit 0
}

fail ()
{
    rm -rf $tempdir;
    exit 1
}

no_result ()
{
    rm -rf $tempdir;
    exit 2
}


cat <<EOF  > $tempdir/cmds
reset-bdm
sync
write-regs x 0xabcdef y 0x123456 sp 0xFFEEDD d0 0x12 d1 0x34 d2 0x5678 d3 0x9abc d4 0x5678 d5 0x9abc d6 0x9abcef1 d7 0x12345678 pc 0xFEDCBA ccw 0x80FF
read-all-regs
write-regs d5 0x5678 d6 0x12345678 d7 0xabcdef01 pc 0x0000 ccw 0x0001 d0 0x01 d1 0x02 d2 0x3456 d3 0x7890 d4 0x1234
read-all-regs
EOF
if test $? -ne 0; then no_result; fi

$BINARY --no-bounce -T $tempdir/cmds | grep -v 'bit period'  > $tempdir/result
if test $? -ne 0; then no_result; fi

diff $tempdir/result - << 'EOF'
 D0: 12
 D1: 34
 D2: 5678
 D3: 9ABC
 D4: 5678
 D5: 9ABC
 D6: 09ABCEF1
 D7: 12345678
  X: ABCDEF
  Y: 123456
 SP: FFEEDD
 PC: FEDCBA
CCW: U----000SX-INZVC
 D0: 01
 D1: 02
 D2: 3456
 D3: 7890
 D4: 1234
 D5: 5678
 D6: 12345678
 D7: ABCDEF01
  X: ABCDEF
  Y: 123456
 SP: FFEEDD
 PC: 000000
CCW: u----000sx-inzvC
EOF
if test $? -ne 0; then fail; fi

pass
