#!/bin/sh
# upad - A program for debugging, and uploading code to embedded devices.
# Copyright (C) 2016 John Darrington

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


tempdir=$(mktemp -d)

pass ()
{
    rm -rf $tempdir;
    exit 0
}

fail ()
{
    rm -rf $tempdir;
    exit 1
}

no_result ()
{
    rm -rf $tempdir;
    exit 2
}


$BINARY --no-bounce -e foo-bar.srec 2> $tempdir/errmsg
if test $? -eq 0; then fail; fi

diff $tempdir/errmsg - << EOF
A filename should not be specified together with -e .
EOF
if test $? -ne 0; then fail; fi

pass

