/*
    upad - A program for debugging, and uploading code to embedded devices.
    Copyright (C) 2016 John Darrington

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include <config.h>
#include <ctype.h>
#include "registers.h"

const int n_registers = 13;

const struct cpu_reg registers[] =
  {
    {"D0",  1},
    {"D1",  1},
    {"D2",  2},
    {"D3",  2},
    {"D4",  2},
    {"D5",  2},
    {"D6",  4},
    {"D7",  4},
    {"X",   3},
    {"Y",   3},
    {"SP",  3},
    {"PC",  3},
    {"CCW", 2}
  };

static const char ccw_bits[] = {
  'C',
  'V',
  'Z',
  'N',
  'I',
  '-',
  'X',
  'S',
  '0',
  '0',
  '0',
  '-',
  '-',
  '-',
  '-',
  'U'
};

void
ccw_print (FILE *stream, uint32_t ccw)
{
  int b;
  for (b = 15; b >= 0; --b)
    {
      if (ccw & (0x1u << b))
	{
	  if (ccw_bits[b] == 0)
	    fputc ('1', stream);
	  else
	    fputc (ccw_bits[b], stream);
	}
      else
	fputc (tolower (ccw_bits[b]), stream);
    }
}
