/*
  upad - A program for debugging, and uploading code to embedded devices.
  Copyright (C) 2016 John Darrington

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include <config.h>

#include "target.h"
#include "Controller/commands.h"

const struct memsector memmap[] =
{
  {MEMCLASS_RAM,    CMD_WRITE_MEM, 1,   1, 0x1000,   8192},
  {MEMCLASS_EEPROM, CMD_EEPROM,    4,   1, 0x100000, 2048},
  {MEMCLASS_PFLASH, CMD_PFLASH,    512, 8, 0xFE0000, 128 * 1024}
};

const int n_memsectors = 3;
