/*
  Copyright (C) 2016 John Darrington

  Copying and distribution of this file, with or without modification,
  are permitted in any medium without royalty provided the copyright
  notice and this notice are preserved.  This file is offered as-is,
  without any warranty.
*/
#include <stdint.h>

#define __IOM volatile
#define __IM volatile const
#define __OM volatile

typedef struct
{
    __IOM uint8_t  FCLKDIV;               /*!< 0x0380 */
    __IM  uint8_t  FSEC;                  /*!< 0x0381 */
    __IOM uint8_t  FCCOBIX;               /*!< 0x0382 */
    __IOM uint8_t  FPSTAT;                /*!< 0x0383 */
    __IOM uint8_t  FCNFG;                 /*!< 0x0384 */
    __IOM uint8_t  FERCHNG;               /*!< 0x0385 */
    __IOM uint8_t  FSTAT;                 /*!< 0x0386 */
    __IOM uint8_t  FERSTAT;               /*!< 0x0387 */
    __IOM uint8_t  FPROT;                 /*!< 0x0388 */
    __IOM uint8_t  DFPROT;                /*!< 0x0389 */
    __IM  uint8_t  FOPT;                  /*!< 0x038A */
    __IM  uint8_t  FRSV1;                 /*!< 0x038B */
    __IOM uint16_t FCCOB[6];              /*!< 0x038C */
} FTMRZ_TypeDef;

#define FTMRZ_BASE (0x0380U)
#define FTMRZ ((FTMRZ_TypeDef *) FTMRZ_BASE)
