/*
  upad - A program for debugging, and uploading code to embedded devices.
  Copyright (C) 2016 John Darrington

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef TARGET_H
#define TARGET_H

#include <stdint.h>

enum memclass
{
    MEMCLASS_OTHER,
    MEMCLASS_RAM,
    MEMCLASS_PFLASH,
    MEMCLASS_EEPROM
};

struct memsector
{
    enum memclass klass;

    /* The command byte to write this class of memory */
    uint8_t cmd;

    /* The minimum number of bytes which can be erased in one operation */
    int erase_sector;

    /* The minimum number of bytes which can be written in one operation */
    int write_sector;

    uint32_t address;
    uint32_t size;
};

extern const struct memsector memmap[];

extern const int n_memsectors;

#endif
