/* Copyright (C) 2016 John Darrington

   Copying and distribution of this file, with or without modification,
   are permitted in any medium without royalty provided the copyright
   notice and this notice are preserved.  This file is offered as-is,
   without any warranty. */

#include <stdio.h>
#include <assert.h>
#include <stdlib.h>

enum state
{
    STATE_DEFAULT = 0,
    STATE_SLASH,
    STATE_COMMENT0,
    STATE_COMMENTN,
    STATE_DOCSTRING,
    STATE_STAR1,
};

static int gotten = -1;

static int
xgetch (FILE *fp)
{
  if (gotten != -1)
    {
      int x = gotten;
      gotten = -1;
      return x;
    }
  return getc (fp);
}

static void
xunget (int x)
{
  gotten = x;
}


int
main (int argc, char **argv)
{
    if (argc < 2)
    {
        fprintf (stderr, "Usage: decomment <infile> <outfile>\n");
        exit (1);
    }
    FILE *fpin = fopen (argv[1], "r");
    if (!fpin)
    {
        perror ("Cannot open input file");
        exit (1);
    }

    FILE *fpout = fopen (argv[2], "w");
    if (!fpout)
    {
        perror ("Cannot open output file");
        exit (1);
    }

    enum state state = STATE_DEFAULT;
    int c;
    while ((c = xgetch (fpin)) != EOF)
    {
        switch (state)
        {
        case STATE_DEFAULT:
            if (c == '/')
            {
                state = STATE_SLASH;
            }
            break;
        case STATE_SLASH:
            if (c == '*')
            {
                state = STATE_COMMENT0;
            }
            else if (c == '/')
                state = STATE_SLASH;
            else
                state = STATE_DEFAULT;
            break;
        case STATE_COMMENT0:
            if (c == '-')
            {
                state = STATE_DOCSTRING;
                continue;
            }
            else if (c == '*')
                state = STATE_STAR1;
            else
                state = STATE_COMMENTN;
            break;
        case STATE_COMMENTN:
            if (c == '*')
                state = STATE_STAR1;
            else
                state = STATE_COMMENTN;
            break;
        case STATE_DOCSTRING:
            if (c == '*')
                state = STATE_STAR1;
            break;
        case STATE_STAR1:
            if (c == '/')
            {
                state = STATE_DEFAULT;
            }
            else if (c == '*')
                state = STATE_STAR1;
            else
	      {
                state = STATE_DOCSTRING;
		putc ('*', fpout);
	      }
            break;
        default:
            assert (0);
        }
        if (STATE_DOCSTRING == state)
            putc (c, fpout);
    }

    fclose (fpin);
    fclose (fpout);
    return 0;
}
