/*
  upad - A program for debugging, and uploading code to embedded devices.
  Copyright (C) 2016 John Darrington

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include <config.h>
#include "binary-uploader.h"
#include "misc.h"
#include <string.h>

struct binary_upload
{
  struct upload_format parent;
  FILE *fp;
  uint32_t load_address;
  uint32_t offset;
};

static bool
binary_get_data_fragment (struct upload_format *uf, uint32_t *address,
                          uint8_t *data, size_t bufsize, size_t *n_data)
{
  struct binary_upload *sru = (struct binary_upload *) uf;
  if (feof (sru->fp))
    return false;

  *n_data = fread (data, 1, bufsize, sru->fp);
  if (*n_data < 0)
    return false;

  *address = sru->offset + sru->load_address;
  sru->offset += *n_data;

  return true;
}

static void
destroy_binary_uploader (struct upload_format *u)
{
  free (u);
}

struct upload_format *
create_binary_uploader (FILE *fp, uint32_t load_address)
{
  struct binary_upload *sru = safe_realloc (NULL, sizeof (*sru));
  memset (sru, 0, sizeof (*sru));
  sru->fp = fp;
  ((struct upload_format *)sru)->get_data_fragment = binary_get_data_fragment;
  ((struct upload_format *)sru)->destroy = destroy_binary_uploader;
  sru->load_address = load_address;
  return (struct upload_format *) sru;
}

