/* quoting.h - Various routines for working with quoted strings
 *
 * Copyright (C) 2005 Oskar Liljeblad
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef QUOTING_H
#define QUOTING_H

#include <stdlib.h>

char *quote_word(const char *string, bool quoted, bool add_end_quote);
char *dequote_words(const char *str, bool quoted, const char *end);
int get_word_index(const char *str, int pos);
char *get_completion_word_dequoted(const char *str, int pos);
char *get_words_dequoted(const char *str, int index, size_t count);

char *get_subwords_dequoted(const char *str, const char *strend, int index, size_t count);
#define get_words_dequoted(str,index,count) get_subwords_dequoted(str,NULL,index,count)
#define get_subword_dequoted(str,strend,index) get_subwords_dequoted(str,strend,index,1)
#define get_word_dequoted(str,index) get_words_dequoted(str,index,1)

char **get_word_array_dequoted(const char *str, const char *strend, int *argc);

int char_is_quoted(char *string, int index);

#endif
