/* hmap_internal.h - Unexported internal features for HMap
 *
 * Copyright (C) 2004-2005 Oskar Liljeblad
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef HMAP_INTERNAL_H
#define HMAP_INTERNAL_H

#include <stdint.h>
#include <stdlib.h>
#include "hmap.h"

#define DEFAULT_CAPACITY    11
#define DEFAULT_LOAD_FACTOR 0.75F

typedef struct _HMapEntry HMapEntry;
typedef struct _HMapIteratorPriv HMapIteratorPriv;

struct _HMapEntry {
    void *key;
    void *value;
    HMapEntry *next;
};

struct _HMap {
    HMapEntry **buckets;
    uint32_t buckets_length;
    uint32_t threshold;
    float load_factor;
    uint32_t size;

    hash_fn_t hash;
    comparison_fn_t compare;
};

struct _HMapIteratorPriv {
    bool (*has_next)(HMapIterator *it);
    void *(*next)(HMapIterator *it);

    HMap *map;
    uint32_t index;
    HMapEntry *entry;
    HMapEntry *previous_entry;
};

#endif
