/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mib.type;

import net.percederberg.mib.type.Constraint;
import net.percederberg.mib.type.TypeConverter;
import net.percederberg.mib.type.ValueConstraint;
import net.percederberg.mib.type.ValueRangeConstraint;

public class SizeConstraint
extends Constraint {
    private ValueConstraint fixedValue;
    private ValueRangeConstraint range;

    public SizeConstraint(ValueConstraint value) {
        this.fixedValue = value;
        this.range = null;
    }

    public SizeConstraint(ValueRangeConstraint range) {
        this.fixedValue = null;
        this.range = range;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SizeConstraint) {
            SizeConstraint c = (SizeConstraint)obj;
            return Constraint.equalsValue(this.fixedValue, c.fixedValue) && Constraint.equalsValue(this.range, c.range);
        }
        return false;
    }

    public String toString() {
        if (this.fixedValue != null) {
            return "SIZE " + this.fixedValue;
        }
        return "SIZE " + this.range;
    }

    public void transferConstraint(TypeConverter converter) {
        if (this.fixedValue == null) {
            converter.transferSizeLimits(this.range.minValue(), this.range.maxValue());
        } else {
            converter.transferSizeLimits(this.fixedValue.value(), this.fixedValue.value());
        }
    }
}

