/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mib;

class Message {
    public static final int ERROR = 0;
    public static final int WARNING = 1;
    public static final int OTHER = 2;
    private static final String[] MESSAGE_DESCRIPTIONS = new String[]{"ERROR", "Warning", "Message"};
    protected int type;
    protected String message;
    protected int firstLine;
    protected int lastLine;

    public Message(String message) {
        this(2, message);
    }

    public Message(int type, String message) {
        this(type, message, -1, -1);
    }

    public Message(int type, String message, int firstLine, int lastLine) {
        this.type = type;
        this.message = message;
        this.firstLine = firstLine;
        this.lastLine = lastLine <= 0 ? firstLine : lastLine;
    }

    public String toString() {
        return MESSAGE_DESCRIPTIONS[this.type] + this.linesToString() + ": " + this.message;
    }

    private String linesToString() {
        if (this.firstLine > 0 && this.firstLine != this.lastLine) {
            return " (lines " + this.firstLine + "-" + this.lastLine + ")";
        }
        if (this.firstLine > 0) {
            return " (line " + this.firstLine + ")";
        }
        return "";
    }
}

