/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.output;

import java.io.IOException;
import java.util.HashMap;
import net.percederberg.grammatica.code.java.JavaComment;
import net.percederberg.grammatica.code.java.JavaFile;
import net.percederberg.grammatica.code.java.JavaInterface;
import net.percederberg.grammatica.code.java.JavaVariable;
import net.percederberg.grammatica.output.JavaParserGenerator;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.TokenPattern;

class JavaConstantsFile {
    private static final String TYPE_COMMENT = "An interface with constants for the parser and tokenizer.";
    private static final String TOKEN_COMMENT = "A token identity constant.";
    private static final String PRODUCTION_COMMENT = "A production node identity constant.";
    private JavaParserGenerator gen;
    private JavaFile file;
    private JavaInterface ifc;
    private HashMap constantNames = new HashMap();

    public JavaConstantsFile(JavaParserGenerator gen) {
        this.gen = gen;
        this.file = gen.createJavaFile();
        int modifiers = gen.getPublicAccess() ? 0 : 2;
        this.ifc = new JavaInterface(modifiers, gen.getBaseName() + "Constants");
        this.initializeCode();
    }

    private void initializeCode() {
        this.file.addInterface(this.ifc);
        String str = this.file.toString() + "\n\n" + this.gen.getFileComment();
        this.file.addComment(new JavaComment(1, str));
        str = TYPE_COMMENT;
        if (this.gen.getClassComment() != null) {
            str = str + "\n\n" + this.gen.getClassComment();
        }
        this.ifc.addComment(new JavaComment(str));
    }

    public void addToken(TokenPattern pattern) {
        String constant = this.gen.getCodeStyle().getUpperCase(pattern.getName());
        int modifiers = 20;
        JavaVariable var = new JavaVariable(modifiers, "int", constant, "" + pattern.getId());
        var.addComment(new JavaComment(TOKEN_COMMENT));
        this.ifc.addVariable(var);
        this.constantNames.put(new Integer(pattern.getId()), constant);
    }

    public void addProduction(ProductionPattern pattern) {
        if (!pattern.isSyntetic()) {
            String constant = this.gen.getCodeStyle().getUpperCase(pattern.getName());
            int modifiers = 20;
            JavaVariable var = new JavaVariable(modifiers, "int", constant, "" + pattern.getId());
            var.addComment(new JavaComment(PRODUCTION_COMMENT));
            this.ifc.addVariable(var);
            this.constantNames.put(new Integer(pattern.getId()), constant);
        }
    }

    public String getConstant(int id) {
        String name = (String)this.constantNames.get(new Integer(id));
        if (name == null) {
            return null;
        }
        return this.ifc.toString() + "." + name;
    }

    public void writeCode() throws IOException {
        this.file.writeCode(this.gen.getCodeStyle());
    }
}

