/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code.csharp;

import java.io.PrintWriter;
import java.util.Vector;
import net.percederberg.grammatica.code.CodeElement;
import net.percederberg.grammatica.code.CodeStyle;
import net.percederberg.grammatica.code.csharp.CSharpComment;
import net.percederberg.grammatica.code.csharp.CSharpModifier;

public class CSharpMethod
extends CodeElement {
    public static final int PUBLIC = 1;
    public static final int PROTECTED_INTERNAL = 2;
    public static final int PROTECTED = 3;
    public static final int INTERNAL = 4;
    public static final int PRIVATE = 5;
    public static final int STATIC = 8;
    public static final int NEW = 16;
    public static final int VIRTUAL = 32;
    public static final int SEALED = 64;
    public static final int OVERRIDE = 128;
    public static final int ABSTRACT = 256;
    public static final int EXTERN = 512;
    private int modifiers;
    private String name;
    private String args;
    private String returnType;
    private Vector code;
    private CSharpComment comment;
    private boolean printCode;

    public CSharpMethod(String name) {
        this(name, "");
    }

    public CSharpMethod(String name, String args) {
        this(name, args, "void");
    }

    public CSharpMethod(String name, String args, String returnType) {
        this(1, name, args, returnType);
    }

    public CSharpMethod(int modifiers, String name, String args, String returnType) {
        this.modifiers = modifiers;
        this.name = name;
        this.args = args;
        this.returnType = returnType;
        this.code = new Vector();
        this.comment = null;
        this.printCode = true;
    }

    public void addCode(String codeLines) {
        int pos = codeLines.indexOf(10);
        while (pos >= 0) {
            this.code.add(codeLines.substring(0, pos));
            codeLines = codeLines.substring(pos + 1);
            pos = codeLines.indexOf(10);
        }
        this.code.add(codeLines);
    }

    public void addComment(CSharpComment comment) {
        this.comment = comment;
    }

    public int category() {
        return (this.modifiers & 8) > 0 ? 6 : 8;
    }

    public boolean canPrintCode() {
        return this.printCode && (this.modifiers & 0x100) == 0;
    }

    public void setPrintCode(boolean value) {
        this.printCode = value;
    }

    public void print(PrintWriter out, CodeStyle style, int indent) {
        String indentStr = style.getIndent(indent);
        String codeIndentStr = style.getIndent(indent + 1);
        StringBuffer res = new StringBuffer();
        if (this.comment != null) {
            this.comment.print(out, style, indent);
        }
        res.append(indentStr);
        res.append(CSharpModifier.createModifierDecl(this.modifiers));
        res.append(this.returnType);
        res.append(" ");
        res.append(this.name);
        res.append("(");
        res.append(this.args);
        res.append(")");
        if (this.canPrintCode()) {
            res.append(" {\n");
            for (int i = 0; i < this.code.size(); ++i) {
                if (this.code.elementAt(i).toString().length() > 0) {
                    res.append(codeIndentStr);
                    res.append(this.code.elementAt(i).toString());
                    res.append("\n");
                    continue;
                }
                res.append("\n");
            }
            res.append(indentStr);
            res.append("}");
        } else {
            res.append(";");
        }
        out.println(res.toString());
    }
}

