/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.value;

import java.util.ArrayList;
import java.util.BitSet;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.value.NumberValue;
import net.percederberg.mibble.value.ValueReference;

public class BitSetValue
extends MibValue {
    private BitSet value;
    private ArrayList references;

    public BitSetValue(BitSet value) {
        this(value, null);
    }

    public BitSetValue(BitSet value, ArrayList references) {
        super("BIT STRING");
        this.value = value;
        this.references = references;
    }

    public MibValue initialize(MibLoaderLog log) throws MibException {
        if (this.references != null) {
            for (int i = 0; i < this.references.size(); ++i) {
                this.initialize(log, (ValueReference)this.references.get(i));
            }
            this.references = null;
        }
        return this;
    }

    public MibValue createReference() {
        return new BitSetValue(this.value, this.references);
    }

    private void initialize(MibLoaderLog log, ValueReference ref) throws MibException {
        MibValue value = ref.initialize(log);
        if (!(value instanceof NumberValue)) {
            throw new MibException(ref.getLocation(), "referenced value is not a number");
        }
        this.value.set(((Number)value.toObject()).intValue());
    }

    public ArrayList getBits() {
        ArrayList<NumberValue> components = new ArrayList<NumberValue>();
        for (int i = 0; i < this.value.size(); ++i) {
            if (!this.value.get(i)) continue;
            components.add(new NumberValue(new Integer(i)));
        }
        return components;
    }

    public Object toObject() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }
}

