/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.type;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibTypeTag;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.type.CompoundConstraint;
import net.percederberg.mibble.type.Constraint;
import net.percederberg.mibble.type.ValueConstraint;
import net.percederberg.mibble.value.BitSetValue;
import net.percederberg.mibble.value.NumberValue;

public class BitSetType
extends MibType
implements MibContext {
    private Constraint constraint = null;
    private HashMap symbols = new HashMap();

    public BitSetType() {
        this(true, null, null);
    }

    public BitSetType(Constraint constraint) {
        this(true, constraint, null);
    }

    public BitSetType(ArrayList values) {
        this(true, null, null);
        this.createValueConstraints(values);
    }

    private BitSetType(boolean primitive, Constraint constraint, HashMap symbols) {
        super("BITS", primitive);
        if (constraint != null) {
            this.constraint = constraint;
        }
        if (symbols != null) {
            this.symbols = symbols;
        }
        this.setTag(true, MibTypeTag.BIT_STRING);
    }

    public MibType initialize(MibSymbol symbol, MibLoaderLog log) throws MibException {
        Iterator iter = this.symbols.values().iterator();
        if (this.constraint != null) {
            this.constraint.initialize(log);
        }
        while (iter.hasNext()) {
            MibValueSymbol sym = (MibValueSymbol)iter.next();
            sym.initialize(log);
            if (sym.getValue() instanceof NumberValue) continue;
            String message = "value is not compatible with type";
            throw new MibException(sym.getLocation(), message);
        }
        return this;
    }

    public MibType createReference() {
        BitSetType type = new BitSetType(false, this.constraint, this.symbols);
        type.setTag(true, this.getTag());
        return type;
    }

    public MibType createReference(Constraint constraint) {
        BitSetType type = new BitSetType(false, constraint, null);
        type.setTag(true, this.getTag());
        return type;
    }

    public MibType createReference(ArrayList values) {
        BitSetType type = new BitSetType(false, null, null);
        type.createValueConstraints(values);
        type.setTag(false, this.getTag());
        return type;
    }

    private void createValueConstraints(ArrayList values) {
        for (int i = 0; i < values.size(); ++i) {
            if (!(values.get(i) instanceof MibValueSymbol)) continue;
            MibValueSymbol sym = (MibValueSymbol)values.get(i);
            this.symbols.put(sym.getName(), sym);
            ValueConstraint c = new ValueConstraint(sym.getValue());
            this.constraint = this.constraint == null ? c : new CompoundConstraint(this.constraint, c);
        }
    }

    public boolean hasConstraint() {
        return this.constraint != null;
    }

    public boolean hasSymbols() {
        return this.symbols.size() > 0;
    }

    public boolean isCompatible(MibValue value) {
        return value instanceof BitSetValue && this.isCompatible((BitSetValue)value);
    }

    public boolean isCompatible(BitSetValue value) {
        if (this.constraint == null) {
            return true;
        }
        ArrayList bits = value.getBits();
        for (int i = 0; i < bits.size(); ++i) {
            if (this.constraint.isCompatible((MibValue)bits.get(i))) continue;
            return false;
        }
        return true;
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public MibSymbol getSymbol(String name) {
        return (MibValueSymbol)this.symbols.get(name);
    }

    public MibValueSymbol[] getAllSymbols() {
        Iterator iter = this.symbols.values().iterator();
        MibValueSymbol[] res = new MibValueSymbol[this.symbols.size()];
        int i = 0;
        while (iter.hasNext()) {
            res[i] = (MibValueSymbol)iter.next();
            ++i;
        }
        return res;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        if (this.constraint != null) {
            buffer.append(" (");
            buffer.append(this.constraint.toString());
            buffer.append(")");
        }
        return buffer.toString();
    }
}

