/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Iterator;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibLoaderException;

public class MibblePrinter {
    private static final String COMMAND_HELP = "Prints the contents of an SNMP MIB file. This program comes with\nABSOLUTELY NO WARRANTY; for details see the LICENSE.txt file.\n\nSyntax: MibblePrinter <file>";
    private static final String INTERNAL_ERROR = "INTERNAL ERROR: An internal error has been found. Please report\n    this error to the maintainers (see the web site for\n    instructions). Be sure to include the version number, as\n    well as the text below:\n";

    public static void main(String[] args) {
        MibLoader loader = new MibLoader();
        Mib mib = null;
        if (args.length < 1) {
            MibblePrinter.printHelp("No MIB file specified");
            System.exit(1);
        } else if (args.length > 1) {
            MibblePrinter.printHelp("Only one MIB file may be specified");
            System.exit(1);
        }
        try {
            File file = new File(args[0]);
            loader.addDir(file.getParentFile());
            mib = loader.load(file);
            if (mib.getLog().warningCount() > 0) {
                mib.getLog().printTo(System.err);
            }
        }
        catch (FileNotFoundException e) {
            MibblePrinter.printError(args[0], e);
            System.exit(1);
        }
        catch (MibLoaderException e) {
            e.getLog().printTo(System.err);
            System.exit(1);
        }
        catch (RuntimeException e) {
            MibblePrinter.printInternalError(e);
            System.exit(1);
        }
        Iterator iter = mib.getAllSymbols().iterator();
        while (iter.hasNext()) {
            System.out.println(iter.next());
            System.out.println();
        }
    }

    private static void printHelp(String error) {
        System.err.println(COMMAND_HELP);
        System.err.println();
        if (error != null) {
            System.err.print("Error: ");
            System.err.println(error);
            System.err.println();
        }
    }

    private static void printInternalError(Exception e) {
        System.err.println(INTERNAL_ERROR);
        e.printStackTrace();
    }

    private static void printError(String file, FileNotFoundException e) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Error: couldn't open file:");
        buffer.append("\n    ");
        buffer.append(file);
        System.out.println(buffer.toString());
    }
}

